var TcHmiCharting;!function(TcHmiCharting){"use strict";TcHmiCharting.Area=class{constructor(canvas){this.__context=null,this.__backgroundColor=null,this.__drawingBorder=0,this.__areas=[],this.__areaPositionAndValue=[],this.__drawLineWithOnePixel=!1,this.__canvas=canvas,void 0!==this.__canvas?this.__context=this.__canvas.getContext("2d"):this.__context=null,this.__areaPositionAndValue=[]}draw(xAxis,yAxis){if(this.__areaPositionAndValue.splice(0,this.__areaPositionAndValue.length),null!==this.__context&&null!==this.__backgroundColor){let yAxisLineWidth=yAxis.getAxisWidth();if(null===yAxisLineWidth)return;let offsetTop=yAxis.getDiffEndLabelAndLine()+yAxisLineWidth/2+5+this.__drawingBorder,offsetLeft=xAxis.getXAxisLeftWidth()||0,xStartValue=xAxis.getMainTickStartValue();if(xAxis.getAutoScaling()){let valueOverride=xAxis.getMainTickStartValueOverride();null!==valueOverride&&(xStartValue=valueOverride)}if(null===xStartValue)return;let xAxisLabel=xAxis.getCalculatedNumbers(),xAxisMainTickSteps=xAxis.getMainTickSteps();if(null===xAxisMainTickSteps)return;let xCalc=xAxis.getLineWidth()/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]);this.__context.beginPath(),this.__context.fillStyle=this.__backgroundColor;let areas=[];for(let i=0,ii=this.__areas.length;i<ii;i++)if(xAxis.getMainTickEndValue()===xAxis.getMainTickStartValue())this.__context.rect(offsetLeft,offsetTop,xAxis.getLineWidth(),yAxis.getLineHeight()),areas.push({xBeginPosition:offsetLeft,xBeginValue:this.__areas[i].beginX,xEndPosition:offsetLeft+xAxis.getLineWidth(),xEndValue:this.__areas[i].endX});else if(this.__drawLineWithOnePixel){let endX=(this.__areas[i].endX-xStartValue)*xCalc+offsetLeft,xEndMiddle=Math.round(endX);this.__context.rect(xEndMiddle-1,offsetTop,1,yAxis.getLineHeight()),areas.push({xBeginPosition:xEndMiddle-1,xBeginValue:this.__areas[i].beginX,xEndPosition:xEndMiddle,xEndValue:this.__areas[i].endX})}else{let beginX=(this.__areas[i].beginX-xStartValue)*xCalc+offsetLeft,endX=(this.__areas[i].endX-xStartValue)*xCalc+offsetLeft,xBeginMiddle=Math.round(beginX),xEndMiddle=Math.round(endX);this.__context.rect(xBeginMiddle,offsetTop,xEndMiddle-xBeginMiddle,yAxis.getHeight()),areas.push({xBeginPosition:xBeginMiddle,xBeginValue:this.__areas[i].beginX,xEndPosition:xEndMiddle,xEndValue:this.__areas[i].endX})}this.__context.fill(),this.__areaPositionAndValue=areas.splice(0)}}setCanvas(canvas){this.__canvas=canvas,this.__context=this.__canvas.getContext("2d")}getCanvas(){return this.__canvas}setDrawingBorder(drawingBorder){this.__drawingBorder=drawingBorder}getAreas(){return this.__areas}removeAllAreas(){this.__areas.splice(0,this.__areas.length),this.__areaPositionAndValue.splice(0,this.__areaPositionAndValue.length)}getAreasPositionAndValue(){return this.__areaPositionAndValue}addArea(area){this.__areas.push(area)}setBackgroundColor(backgroundColor){this.__backgroundColor=backgroundColor}getBackgroundColor(){return this.__backgroundColor}setDrawLineWithOnePixel(drawLineWithOnePixel=!1){this.__drawLineWithOnePixel=drawLineWithOnePixel}getDrawLineWithOnePixel(){return this.__drawLineWithOnePixel}}}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";TcHmiCharting.IChart=class{constructor(elementRoot,canvasWidth,canvasHeight){this.__canvasFrame=null,this.__canvasDrawing=null,this.__contextFrame=null,this.__contextDrawing=null,this.__canvasGraph=null,this.__xAxis=null,this.__grid=null,this.__subgrid=null,this.__yAxisWidth=null,this.__yLabelFontFamily=null,this.__yLabelFontSize=null,this.__yLabelFontSizeUnit="px",this.__yLabelFontWeight=null,this.__yShowLabels=!0,this.__yMainTickSteps=null,this.__ySubTickSteps=null,this.__showYSubTicks=!0,this.__elementRoot=elementRoot,this.__yAxis=[],this.__hasChanged=!1,this.__initCanvas(canvasWidth,canvasHeight)}addXAxis(){if(this.__canvasFrame){let xAxis=new TcHmiCharting.XAxis(1,this.__canvasFrame);this.__xAxis=xAxis,this.__hasChanged=!0}}addYAxis(position){if(this.__canvasFrame){let yAxis=new TcHmiCharting.YAxis(this.__yAxis.length+1,this.__canvasFrame,position);this.__yAxis.push(yAxis),this.__hasChanged=!0}}addYAxisAtPosition(index,position){if(this.__canvasFrame){let yAxis=new TcHmiCharting.YAxis(this.__yAxis.length+1,this.__canvasFrame,position);this.__yAxis.splice(index,0,yAxis),this.__hasChanged=!0}}addGrid(){this.__canvasFrame&&(this.__grid=new TcHmiCharting.Grid(this.__canvasFrame),this.__hasChanged=!0)}deleteGrid(){this.__grid=null,this.__hasChanged=!0}addSubgrid(){this.__canvasFrame&&(this.__subgrid=new TcHmiCharting.Subgrid(this.__canvasFrame),this.__hasChanged=!0)}deleteSubgrid(){this.__subgrid=null,this.__hasChanged=!0}remove(){this.__canvasFrame&&this.__canvasFrame.parentNode&&this.__canvasFrame.parentNode.removeChild(this.__canvasFrame),this.__canvasDrawing&&this.__canvasDrawing.parentNode&&this.__canvasDrawing.parentNode.removeChild(this.__canvasDrawing)}clear(width,height){this.__canvasFrame&&this.__contextFrame&&(this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height),this.__canvasFrame.width=width,this.__canvasFrame.height=height),this.__canvasDrawing&&this.__contextDrawing&&(this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height),this.__canvasDrawing.width=width,this.__canvasDrawing.height=height)}getYAxis(){return this.__yAxis}getYAxisAtPosition(index){return this.__yAxis[index]}getXAxis(){return this.__xAxis}getGrid(){return this.__grid}getSubgrid(){return this.__subgrid}getYAxisWidth(){return this.__yAxisWidth}getYLabelFontFamily(){return this.__yLabelFontFamily}getYLabelFontSize(){return this.__yLabelFontSize}getYLabelFontSizeUnit(){return this.__yLabelFontSizeUnit}getYLabelFontWeight(){return this.__yLabelFontWeight}getYShowLabels(){return this.__yShowLabels}getYMainTickSteps(){return this.__yMainTickSteps}getYSubTickSteps(){return this.__ySubTickSteps}getCanvasDrawing(){return this.__canvasDrawing?$(this.__canvasDrawing):null}getCanvasFrame(){return this.__canvasFrame?$(this.__canvasFrame):null}getHasChanged(){return this.__hasChanged}setYAxisWidth(yAxisWidth){this.__yAxisWidth=yAxisWidth;for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].setAxisWidth(this.__yAxisWidth);this.__hasChanged=!0}setYLabelFontFamily(labelFontFamily){if(labelFontFamily)this.__yLabelFontFamily=labelFontFamily;else if(this.__canvasFrame){const inheritedFontfamily=TcHmi.StyleProvider.getComputedElementStyle(this.__canvasFrame,"font-family")["font-family"];this.__yLabelFontFamily=inheritedFontfamily||null}for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].setLabelFontFamily(this.__yLabelFontFamily);this.__hasChanged=!0}setYLabelFontSize(labelFontSize){if(labelFontSize)this.__yLabelFontSize=labelFontSize;else if(this.__canvasDrawing){const inheritedFontSize=TcHmi.StyleProvider.getComputedElementStyle(this.__canvasDrawing,"font-size")["font-size"];this.__yLabelFontSize=inheritedFontSize?parseFloat(inheritedFontSize):null}this.__yLabelFontSize=labelFontSize;for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].setLabelFontSize(this.__yLabelFontSize);this.__hasChanged=!0}setYLabelFontSizeUnit(labelFontSizeUnit){}setYLabelFontWeight(labelFontWeight){if(labelFontWeight&&"Auto"!==labelFontWeight)this.__yLabelFontWeight=labelFontWeight;else if(this.__canvasFrame){const inheritedFontWeight=TcHmi.StyleProvider.getComputedElementStyle(this.__canvasFrame,"font-weight")["font-weight"];this.__yLabelFontWeight=inheritedFontWeight||null}for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].setLabelFontWeight(this.__yLabelFontWeight);this.__hasChanged=!0}setYShowLabels(yShowLabels){this.__yShowLabels=yShowLabels;for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].setShowLabels(this.__yShowLabels);this.__hasChanged=!0}setYMainTickSteps(yMainTickSteps){this.__yMainTickSteps=yMainTickSteps;for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].setMainTickSteps(this.__yMainTickSteps);this.__hasChanged=!0}setYSubTickSteps(ySubTickSteps){this.__ySubTickSteps=ySubTickSteps;for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].setSubTickSteps(this.__ySubTickSteps);this.__hasChanged=!0}setShowYSubTicks(showYSubTicks){this.__showYSubTicks=showYSubTicks;for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].setShowSubTicks(this.__showYSubTicks);this.__hasChanged=!0}__initCanvas(canvasWidth,canvasHeight){let canvas=document.createElement("canvas"),width=canvasWidth.toString(),height=canvasHeight.toString();canvas.setAttribute("height",height),canvas.setAttribute("width",width),canvas.setAttribute("class","TcHmi_Controls_Beckhoff_Controls-chart-canvas-frame"),canvas.setAttribute("style","position:absolute;width:100%;height:100%;"),canvas.style.backgroundColor="transparent",this.__elementRoot[0].appendChild(canvas),this.__canvasFrame=canvas,this.__contextFrame=this.__canvasFrame.getContext("2d");let canvasDrawing=document.createElement("canvas");canvasDrawing.setAttribute("height",height),canvasDrawing.setAttribute("width",width),canvasDrawing.setAttribute("class","TcHmi_Controls_Beckhoff_Controls-chart-canvas-drawing"),canvasDrawing.style.backgroundColor="transparent",canvasDrawing.setAttribute("style","position:absolute;width:100%;height:100%;"),this.__elementRoot[0].appendChild(canvasDrawing),this.__canvasDrawing=canvasDrawing,this.__contextDrawing=this.__canvasDrawing.getContext("2d")}setHasChanged(hasChanged){this.__hasChanged=hasChanged}}}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class LineChart extends TcHmiCharting.IChart{constructor(elementRoot,canvasWidth,canvasHeight){super(elementRoot,canvasWidth,canvasHeight),this.__widthLeft=null,this.__drawingBorder=0,this.__lineGraph=[],this.__lineGraphs=[],this.__lineChanged=!1}deleteYAxis(index){for(let i=0,ii=this.__lineGraph.length;i<ii;i++){const tempLineGraph=this.__lineGraph[i];null!==tempLineGraph.yAxis&&tempLineGraph.yAxis.getId()===this.__yAxis[index].getId()&&(tempLineGraph.yAxis=null)}this.__yAxis.splice(index,1),this.setHasChanged(!0)}deleteAllYAxis(){this.__yAxis.splice(0,this.__yAxis.length);for(let i=0,ii=this.__lineGraph.length;i<ii;i++)this.__lineGraph[i].yAxis=null;this.setHasChanged(!0)}addGraph(newGraph){this.__canvasFrame&&(this.__lineGraph.push(newGraph),this.__lineGraphs.push(new TcHmiCharting.LineGraph(this.__canvasFrame)),this.__lineChanged=!0)}deleteGraph(index){this.__lineGraph.splice(index,1),this.__lineGraphs[index].removePoints(),this.__lineGraphs.splice(index,1),this.__lineChanged=!0}deleteAllGraphs(){this.__lineGraph.splice(0,this.__lineGraph.length);for(let i=0,ii=this.__lineGraphs.length;i<ii;i++)this.__lineGraphs[i].removePoints();this.__lineGraphs.splice(0,this.__lineGraphs.length),this.__lineChanged=!0}remove(){super.remove(),this.deleteGrid(),this.deleteSubgrid(),this.deleteAllYAxis(),this.deleteAllGraphs(),this.__xAxis=null}clear(width,height){super.clear(width,height),this.deleteGrid(),this.deleteSubgrid(),this.deleteAllYAxis(),this.deleteAllGraphs(),this.__xAxis=null}getLines(){return this.__lineGraph}getLinesAtPosition(index){return this.__lineGraph[index]}getLineGraphs(){return this.__lineGraphs}getLineGraphsAtPosition(index){return this.__lineGraphs[index]}getDrawingBorder(){return this.__drawingBorder}setLineChanged(lineChanged){this.__lineChanged=lineChanged}draw(){if(null!==this.__canvasFrame&&void 0!==this.__canvasFrame)if(null!==this.__xAxis&&void 0!==this.__xAxis){if(this.getHasChanged()){if(null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height),this.__drawingBorder=0,null!==this.__grid){let gridLineWidth=this.__grid.getLineWidth()||0;this.__drawingBorder=gridLineWidth/2}this.__drawingBorder<5&&(this.__drawingBorder=5);let xAxisHeight=0,startValueX=null,endValueX=null;if(this.__xAxis.setMainTickStartValueOverride(null),this.__xAxis.setMainTickEndValueOverride(null),this.__xAxis.getAutoScaling()){for(let j=0,jj=this.__lineGraph.length;j<jj;j++)for(let k=0,kk=this.__lineGraph[j].points.length;k<kk;k++)(null===startValueX||startValueX>this.__lineGraph[j].points[k].x)&&(startValueX=this.__lineGraph[j].points[k].x),(null===endValueX||endValueX<this.__lineGraph[j].points[k].x)&&(endValueX=this.__lineGraph[j].points[k].x);null!==startValueX&&null!==endValueX&&(startValueX===endValueX&&(startValueX-=.5,endValueX+=.5),this.__xAxis.setMainTickStartValueOverride(startValueX),this.__xAxis.setMainTickEndValueOverride(endValueX))}if(this.__xAxis.drawAxis({x:0,y:this.__canvasFrame.height},{x:this.__canvasFrame.width,y:this.__canvasFrame.height}),xAxisHeight=this.__xAxis.getHeight(),xAxisHeight>0?xAxisHeight+=10:xAxisHeight=5,null!==this.__yAxis&&void 0!==this.__yAxis&&this.__yAxis.length>0){null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height);let widthLeft=5,widthRight=5,showOnlyYAxis=!1,biggestFirst=0,biggestLatest=0;for(let h=0,hh=this.__yAxis.length;h<hh;h++){this.__yAxis[h].setMainTickStartValueOverride(null),this.__yAxis[h].setMainTickEndValueOverride(null);let startValue=null,endValue=null;if(this.__yAxis[h].getAutoScaling())for(let j=0,jj=this.__lineGraph.length;j<jj;j++){const tempLineGraph=this.__lineGraph[j];if(null!==tempLineGraph.yAxis&&tempLineGraph.yAxis.getId()===this.__yAxis[h].getId()){for(let k=0,kk=this.__lineGraph[j].points.length;k<kk;k++)(null===startValue||startValue>this.__lineGraph[j].points[k].y)&&(startValue=this.__lineGraph[j].points[k].y),(null===endValue||endValue<this.__lineGraph[j].points[k].y)&&(endValue=this.__lineGraph[j].points[k].y);null!==startValue&&null!==endValue&&(startValue===endValue&&(startValue-=.5,endValue+=.5),this.__yAxis[h].setMainTickStartValueOverride(startValue),this.__yAxis[h].setMainTickEndValueOverride(endValue))}}let yAxis=this.__yAxis[h],labelArray=yAxis.getCalculatedLabels();if(yAxis.getShowAxis()&&yAxis.getShowLabels()){let callback=yAxis.getYAxisCallback(),mainTickSteps=yAxis.getMainTickSteps();if(null!==callback){if(void 0!==labelArray[0]&&null!==labelArray[0]){let first=yAxis.calculateLabelHeight(callback.apply(this,[parseFloat(labelArray[0])]));first>biggestFirst&&(biggestFirst=first)}if(null!==mainTickSteps&&void 0!==labelArray[mainTickSteps-1]&&null!==labelArray[mainTickSteps-1]){let latest=yAxis.calculateLabelHeight(callback.apply(this,[parseFloat(labelArray[mainTickSteps-1])]));latest>biggestLatest&&(biggestLatest=latest)}}else{if(void 0!==labelArray[0]&&null!==labelArray[0]){let first=yAxis.calculateLabelHeight(labelArray[0]);first>biggestFirst&&(biggestFirst=first)}if(null!==mainTickSteps&&void 0!==labelArray[mainTickSteps-1]&&null!==labelArray[mainTickSteps-1]){let latest=yAxis.calculateLabelHeight(labelArray[mainTickSteps-1]);latest>biggestLatest&&(biggestLatest=latest)}}}}for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__xAxis.getShowAxis()||(showOnlyYAxis=!0),this.__yAxis[i].getPosition()===TcHmiCharting.IAxis.Position.Left?(this.__yAxis[i].drawAxis({x:widthLeft,y:this.__canvasFrame.height-xAxisHeight-this.__drawingBorder},{x:widthLeft,y:5+this.__drawingBorder},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),this.__yAxis[i].getShowAxis()&&(widthLeft=widthLeft+10+this.__yAxis[i].getWidth())):(this.__yAxis[i].drawAxis({x:this.__canvasFrame.width-widthRight,y:this.__canvasFrame.height-xAxisHeight-this.__drawingBorder},{x:this.__canvasFrame.width-widthRight,y:5+this.__drawingBorder},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),this.__yAxis[i].getShowAxis()&&(widthRight=widthRight+10+this.__yAxis[i].getWidth()));this.__canvasFrame.width-widthRight-widthLeft>0?this.__xAxis.drawAxis({x:widthLeft+this.__drawingBorder,y:this.__canvasFrame.height},{x:this.__canvasFrame.width-widthRight-this.__drawingBorder,y:this.__canvasFrame.height}):this.__xAxis.drawAxis({x:0,y:0},{x:0,y:0});let xAxisMainTickSteps=this.__xAxis.getMainTickSteps(),yAxisMainTickSteps=this.__yMainTickSteps,xAxisWidth=this.__xAxis.getAxisWidth(),yAxisWidth=this.getYAxisWidth();if(null!==xAxisMainTickSteps&&null!==yAxisMainTickSteps&&null!==xAxisWidth&&null!==yAxisWidth){let xAxisSubTickSteps=this.__xAxis.getSubTickSteps(),yAxisSubTickSteps=this.__ySubTickSteps,showGridHorizontal=!!this.__grid&&this.__grid.getShowHorizontalLines(),showGridVertical=!!this.__grid&&this.__grid.getShowVerticalLines(),showSubgridHorizontal=!!this.__subgrid&&this.__subgrid.getShowHorizontalLines(),showSubgridVertical=!!this.__subgrid&&this.__subgrid.getShowVerticalLines(),gridBackgroundColor=this.__grid?this.__grid.getBackgroundColor():null;((showGridHorizontal||showGridVertical)&&this.__grid&&null!==this.__grid.getLineColor()&&null!==this.__grid.getLineWidth()&&null!==this.__grid.getLineStyle()||(showSubgridHorizontal&&null!==yAxisSubTickSteps||showSubgridVertical&&null!==xAxisSubTickSteps)&&this.__subgrid&&null!==this.__subgrid.getLineColor()&&null!==this.__subgrid.getLineWidth()&&null!==this.__subgrid.getLineStyle())&&this.__contextFrame&&gridBackgroundColor&&(this.__contextFrame.fillStyle=gridBackgroundColor,showOnlyYAxis?this.__contextFrame.fillRect(this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder,this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2,this.__xAxis.getLineWidth()+2*this.__drawingBorder,-this.__yAxis[0].getLineHeight()-2*this.__drawingBorder):this.__contextFrame.fillRect(this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder,this.__canvasFrame.height-xAxisHeight-yAxisWidth/2,this.__xAxis.getLineWidth()+2*this.__drawingBorder,-this.__yAxis[0].getLineHeight()-2*this.__drawingBorder)),this.__subgrid&&this.__grid&&(showOnlyYAxis?this.__subgrid.draw({x:this.__xAxis.getXAxisLeftWidth(),y:this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2-this.__drawingBorder},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisSubTickSteps,this.__xAxis.getLineWidth()/(xAxisMainTickSteps-1),yAxisSubTickSteps,this.__yAxis[0].getLineHeight()/(yAxisMainTickSteps-1),xAxisMainTickSteps,yAxisMainTickSteps,0,{width:this.__drawingBorder,height:this.__drawingBorder}):this.__subgrid.draw({x:this.__xAxis.getXAxisLeftWidth(),y:this.__canvasFrame.height-xAxisHeight-yAxisWidth/2-this.__drawingBorder},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisSubTickSteps,this.__xAxis.getLineWidth()/(xAxisMainTickSteps-1),yAxisSubTickSteps,this.__yAxis[0].getLineHeight()/(yAxisMainTickSteps-1),xAxisMainTickSteps,yAxisMainTickSteps,0,{width:this.__drawingBorder,height:this.__drawingBorder})),this.__grid&&(showOnlyYAxis?this.__grid.draw({x:this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder,y:this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisMainTickSteps,yAxisMainTickSteps,{width:this.__drawingBorder,height:this.__drawingBorder}):this.__grid.draw({x:this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder,y:this.__canvasFrame.height-xAxisHeight-yAxisWidth/2},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisMainTickSteps,yAxisMainTickSteps,{width:this.__drawingBorder,height:this.__drawingBorder}))}this.__lineChanged=!0,this.__widthLeft=this.__xAxis.getXAxisLeftWidth()}}if(this.__lineChanged)if(null!==this.__yAxis&&void 0!==this.__yAxis)if(this.__yAxis.length>0){this.__canvasDrawing&&this.__contextDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);let canvasElem=this.__elementRoot.find(".TcHmi_Controls_Beckhoff_Controls-chart-canvas-drawing")[0];for(let i=0,ii=this.__lineGraph.length;i<ii;i++)if(null!==this.__lineGraph[i].yAxis&&void 0!==this.__lineGraph[i].yAxis){let lineGraph=this.__lineGraphs[i];lineGraph.setCanvas(canvasElem),lineGraph.setDrawingBorder(this.__drawingBorder),lineGraph.draw(this.__lineGraph[i],this.__xAxis)}this.__lineChanged=!1}else this.__canvasDrawing&&this.__contextDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);else this.__canvasDrawing&&this.__contextDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);this.setHasChanged(!1)}else null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height),this.__canvasDrawing&&this.__contextDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height)}}TcHmiCharting.LineChart=LineChart}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class LineAreaChart extends TcHmiCharting.IChart{constructor(elementRoot,canvasWidth,canvasHeight){super(elementRoot,canvasWidth,canvasHeight),this.__widthLeft=null,this.__drawingBorder=0,this.__lineGraph=[],this.__lineGraphs=[],this.__lineChanged=!1}deleteYAxis(index){for(let i=0,ii=this.__lineGraph.length;i<ii;i++){const tempLineGraph=this.__lineGraph[i];tempLineGraph.yAxis&&tempLineGraph.yAxis.getId()===this.__yAxis[index].getId()&&(tempLineGraph.yAxis=null)}this.__yAxis.splice(index,1),this.setHasChanged(!0)}deleteAllYAxis(){this.__yAxis.splice(0,this.__yAxis.length);for(let i=0,ii=this.__lineGraph.length;i<ii;i++)this.__lineGraph[i].yAxis=null;this.setHasChanged(!0)}addGraph(newGraph){this.__canvasFrame&&(this.__lineGraph.push(newGraph),this.__lineGraphs.push(new TcHmiCharting.LineAreaGraph(this.__canvasFrame)),this.__lineChanged=!0)}deleteGraph(index){this.__lineGraph.splice(index,1),this.__lineGraphs[index].removePoints(),this.__lineGraphs[index].removeAreaPoints(),this.__lineGraphs[index].deleteAllAreas(),this.__lineGraphs.splice(index,1),this.__lineChanged=!0}deleteAllGraphs(){this.__lineGraph.splice(0,this.__lineGraph.length);for(let i=0,ii=this.__lineGraphs.length;i<ii;i++)this.__lineGraphs[i].removePoints(),this.__lineGraphs[i].removeAreaPoints(),this.__lineGraphs[i].deleteAllAreas();this.__lineGraphs.splice(0,this.__lineGraphs.length),this.__lineChanged=!0}remove(){super.remove(),this.deleteGrid(),this.deleteSubgrid(),this.deleteAllYAxis(),this.deleteAllGraphs(),this.__xAxis=null}clear(width,height){super.clear(width,height),this.deleteGrid(),this.deleteSubgrid(),this.deleteAllYAxis(),this.deleteAllGraphs(),this.__xAxis=null}getLines(){return this.__lineGraph}getLinesAtPosition(index){return this.__lineGraph[index]}getLineGraphs(){return this.__lineGraphs}getLineGraphsAtPosition(index){return this.__lineGraphs[index]}getDrawingBorder(){return this.__drawingBorder}setLineChanged(lineChanged){this.__lineChanged=lineChanged}draw(){if(null!==this.__canvasFrame&&void 0!==this.__canvasFrame)if(null!==this.__xAxis&&void 0!==this.__xAxis){if(this.getHasChanged()){if(null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height),this.__drawingBorder=0,null!==this.__grid){let gridLineWidth=this.__grid.getLineWidth()||0;this.__drawingBorder=gridLineWidth/2}this.__drawingBorder<5&&(this.__drawingBorder=5);let xAxisHeight=0,startValueX=null,endValueX=null;if(this.__xAxis.setMainTickStartValueOverride(null),this.__xAxis.setMainTickEndValueOverride(null),this.__xAxis.getAutoScaling()){for(let j=0,jj=this.__lineGraph.length;j<jj;j++)for(let k=0,kk=this.__lineGraph[j].points.length;k<kk;k++)(null===startValueX||startValueX>this.__lineGraph[j].points[k].x)&&(startValueX=this.__lineGraph[j].points[k].x),(null===endValueX||endValueX<this.__lineGraph[j].points[k].x)&&(endValueX=this.__lineGraph[j].points[k].x);null!==startValueX&&null!==endValueX&&(startValueX===endValueX&&(startValueX-=.5,endValueX+=.5),this.__xAxis.setMainTickStartValueOverride(startValueX),this.__xAxis.setMainTickEndValueOverride(endValueX))}if(this.__xAxis.drawAxis({x:0,y:this.__canvasFrame.height},{x:this.__canvasFrame.width,y:this.__canvasFrame.height}),xAxisHeight=this.__xAxis.getHeight(),xAxisHeight>0?xAxisHeight+=10:xAxisHeight=5,null!==this.__yAxis&&void 0!==this.__yAxis&&this.__yAxis.length>0){null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height);let widthLeft=5,widthRight=5,showOnlyYAxis=!1,biggestFirst=0,biggestLatest=0;for(let h=0,hh=this.__yAxis.length;h<hh;h++){this.__yAxis[h].setMainTickStartValueOverride(null),this.__yAxis[h].setMainTickEndValueOverride(null);let startValue=null,endValue=null;if(this.__yAxis[h].getAutoScaling())for(let j=0,jj=this.__lineGraph.length;j<jj;j++){const tempLineGraph=this.__lineGraph[j];if(tempLineGraph.yAxis&&tempLineGraph.yAxis.getId()===this.__yAxis[h].getId()){for(let k=0,kk=this.__lineGraph[j].points.length;k<kk;k++){let yValue=this.__lineGraph[j].points[k].y;void 0!==yValue&&((null===startValue||startValue>yValue)&&(startValue=yValue),(null===endValue||yValue&&endValue<yValue)&&(endValue=yValue))}null!==startValue&&null!==endValue&&(startValue===endValue&&(startValue-=.5,endValue+=.5),this.__yAxis[h].setMainTickStartValueOverride(startValue),this.__yAxis[h].setMainTickEndValueOverride(endValue))}}let yAxis=this.__yAxis[h],labelArray=yAxis.getCalculatedLabels();if(yAxis.getShowAxis()&&yAxis.getShowLabels()){let callback=yAxis.getYAxisCallback(),mainTickSteps=yAxis.getMainTickSteps();if(null!==callback){if(void 0!==labelArray[0]&&null!==labelArray[0]){let first=yAxis.calculateLabelHeight(callback.apply(this,[parseFloat(labelArray[0])]));first>biggestFirst&&(biggestFirst=first)}if(null!==mainTickSteps&&void 0!==labelArray[mainTickSteps-1]&&null!==labelArray[mainTickSteps-1]){let latest=yAxis.calculateLabelHeight(callback.apply(this,[parseFloat(labelArray[mainTickSteps-1])]));latest>biggestLatest&&(biggestLatest=latest)}}else{if(void 0!==labelArray[0]&&null!==labelArray[0]){let first=yAxis.calculateLabelHeight(labelArray[0]);first>biggestFirst&&(biggestFirst=first)}if(null!==mainTickSteps&&void 0!==labelArray[mainTickSteps-1]&&null!==labelArray[mainTickSteps-1]){let latest=yAxis.calculateLabelHeight(labelArray[mainTickSteps-1]);latest>biggestLatest&&(biggestLatest=latest)}}}}for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__xAxis.getShowAxis()||(showOnlyYAxis=!0),this.__yAxis[i].getPosition()===TcHmiCharting.IAxis.Position.Left?(this.__yAxis[i].drawAxis({x:widthLeft,y:this.__canvasFrame.height-xAxisHeight-this.__drawingBorder},{x:widthLeft,y:5+this.__drawingBorder},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),this.__yAxis[i].getShowAxis()&&(widthLeft=widthLeft+10+this.__yAxis[i].getWidth())):(this.__yAxis[i].drawAxis({x:this.__canvasFrame.width-widthRight,y:this.__canvasFrame.height-xAxisHeight-this.__drawingBorder},{x:this.__canvasFrame.width-widthRight,y:5+this.__drawingBorder},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),this.__yAxis[i].getShowAxis()&&(widthRight=widthRight+10+this.__yAxis[i].getWidth()));this.__canvasFrame.width-widthRight-widthLeft>0?this.__xAxis.drawAxis({x:widthLeft+this.__drawingBorder,y:this.__canvasFrame.height},{x:this.__canvasFrame.width-widthRight-this.__drawingBorder,y:this.__canvasFrame.height}):this.__xAxis.drawAxis({x:0,y:0},{x:0,y:0});let xAxisMainTickSteps=this.__xAxis.getMainTickSteps(),yAxisMainTickSteps=this.__yMainTickSteps,xAxisWidth=this.__xAxis.getAxisWidth(),yAxisWidth=this.getYAxisWidth();if(null!==xAxisMainTickSteps&&null!==yAxisMainTickSteps&&null!==xAxisWidth&&null!==yAxisWidth){let xAxisSubTickSteps=this.__xAxis.getSubTickSteps(),yAxisSubTickSteps=this.__ySubTickSteps,showGridHorizontal=!!this.__grid&&this.__grid.getShowHorizontalLines(),showGridVertical=!!this.__grid&&this.__grid.getShowVerticalLines(),showSubgridHorizontal=!!this.__subgrid&&this.__subgrid.getShowHorizontalLines(),showSubgridVertical=!!this.__subgrid&&this.__subgrid.getShowVerticalLines(),gridBackgroundColor=this.__grid?this.__grid.getBackgroundColor():null;((showGridHorizontal||showGridVertical)&&this.__grid&&null!==this.__grid.getLineColor()&&null!==this.__grid.getLineWidth()&&null!==this.__grid.getLineStyle()||(showSubgridHorizontal&&null!==yAxisSubTickSteps||showSubgridVertical&&null!==xAxisSubTickSteps)&&this.__subgrid&&null!==this.__subgrid.getLineColor()&&null!==this.__subgrid.getLineWidth()&&null!==this.__subgrid.getLineStyle())&&this.__contextFrame&&gridBackgroundColor&&(this.__contextFrame.fillStyle=gridBackgroundColor,showOnlyYAxis?this.__contextFrame.fillRect(this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder,this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2,this.__xAxis.getLineWidth()+2*this.__drawingBorder,-this.__yAxis[0].getLineHeight()-2*this.__drawingBorder):this.__contextFrame.fillRect(this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder,this.__canvasFrame.height-xAxisHeight-yAxisWidth/2,this.__xAxis.getLineWidth()+2*this.__drawingBorder,-this.__yAxis[0].getLineHeight()-2*this.__drawingBorder)),this.__subgrid&&this.__grid&&(this.__subgrid.setBackgroundColor(this.__grid.getBackgroundColor()),showOnlyYAxis?this.__subgrid.draw({x:this.__xAxis.getXAxisLeftWidth(),y:this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2-this.__drawingBorder},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisSubTickSteps,this.__xAxis.getLineWidth()/(xAxisMainTickSteps-1),yAxisSubTickSteps,this.__yAxis[0].getLineHeight()/(yAxisMainTickSteps-1),xAxisMainTickSteps,yAxisMainTickSteps,0,{width:this.__drawingBorder,height:this.__drawingBorder}):this.__subgrid.draw({x:this.__xAxis.getXAxisLeftWidth(),y:this.__canvasFrame.height-xAxisHeight-yAxisWidth/2-this.__drawingBorder},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisSubTickSteps,this.__xAxis.getLineWidth()/(xAxisMainTickSteps-1),yAxisSubTickSteps,this.__yAxis[0].getLineHeight()/(yAxisMainTickSteps-1),xAxisMainTickSteps,yAxisMainTickSteps,0,{width:this.__drawingBorder,height:this.__drawingBorder})),this.__grid&&(showOnlyYAxis?this.__grid.draw({x:this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder,y:this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisMainTickSteps,yAxisMainTickSteps,{width:this.__drawingBorder,height:this.__drawingBorder}):this.__grid.draw({x:this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder,y:this.__canvasFrame.height-xAxisHeight-yAxisWidth/2},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisMainTickSteps,yAxisMainTickSteps,{width:this.__drawingBorder,height:this.__drawingBorder}))}this.__lineChanged=!0,this.__widthLeft=this.__xAxis.getXAxisLeftWidth()}}if(this.__lineChanged)if(null!==this.__yAxis&&void 0!==this.__yAxis)if(this.__yAxis.length>0){this.__canvasDrawing&&this.__contextDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);let canvasElem=this.__elementRoot.find(".TcHmi_Controls_Beckhoff_Controls-chart-canvas-drawing")[0];for(let i=0,ii=this.__lineGraph.length;i<ii;i++)if(null!==this.__lineGraph[i].yAxis&&void 0!==this.__lineGraph[i].yAxis){let lineGraph=this.__lineGraphs[i];lineGraph.setCanvas(canvasElem),lineGraph.setDrawingBorder(this.__drawingBorder),lineGraph.drawAreas(this.__lineGraph[i],this.__xAxis)}for(let i=0,ii=this.__lineGraph.length;i<ii;i++)if(null!==this.__lineGraph[i].yAxis&&void 0!==this.__lineGraph[i].yAxis){this.__lineGraphs[i].drawPoints(this.__lineGraph[i],this.__xAxis)}this.__lineChanged=!1}else this.__canvasDrawing&&this.__contextDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);else this.__canvasDrawing&&this.__contextDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);this.setHasChanged(!1)}else null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height),this.__canvasDrawing&&this.__contextDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height)}}TcHmiCharting.LineAreaChart=LineAreaChart}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class BarChart extends TcHmiCharting.IChart{constructor(elementRoot,canvasWidth,canvasHeight){super(elementRoot,canvasWidth,canvasHeight),this.__widthLeft=0,this.__calcBarWidth=0,this.__barWidth=null,this.__barGraphArrangement=null,this.__drawingBorder={height:0,width:0},this.__barGraph=[],this.__barGraphs=[],this.__barChanged=!1}deleteYAxis(index){for(let i=0,ii=this.__barGraph.length;i<ii;i++){const tempBarGraph=this.__barGraph[i];null!==tempBarGraph.yAxis&&tempBarGraph.yAxis.getId()===this.__yAxis[index].getId()&&(tempBarGraph.yAxis=null)}this.__yAxis.splice(index,1),this.setHasChanged(!0)}deleteAllYAxis(){this.__yAxis.splice(0,this.__yAxis.length);for(let i=0,ii=this.__barGraph.length;i<ii;i++)this.__barGraph[i].yAxis=null;this.setHasChanged(!0)}addGraph(newGraph){this.__canvasFrame&&(this.__barGraph.push(newGraph),this.__barGraphs.push(new TcHmiCharting.BarGraph(this.__canvasFrame)),this.__barChanged=!0)}deleteGraph(index){this.__barGraph.splice(index,1),this.__barGraphs.splice(index,1),this.__barChanged=!0}deleteAllGraphs(){this.__barGraph.splice(0,this.__barGraph.length),this.__barGraphs.splice(0,this.__barGraphs.length),this.__barChanged=!0}remove(){super.remove(),this.deleteGrid(),this.deleteSubgrid(),this.deleteAllYAxis(),this.deleteAllGraphs(),this.__xAxis=null,this.__barWidth=null}clear(width,height){super.clear(width,height),this.deleteGrid(),this.deleteSubgrid(),this.deleteAllYAxis(),this.deleteAllGraphs(),this.__xAxis=null,this.__barWidth=null}getBars(){return this.__barGraph}getBarsAtPosition(index){return this.__barGraph[index]}getBarGraphs(){return this.__barGraphs}getBarGraphsAtPosition(index){return this.__barGraphs[index]}setBarWidth(barWidth){this.__barWidth=barWidth}setBarGraphArrangement(barGraphArrangement){this.__barGraphArrangement=barGraphArrangement}setBarChanged(barChanged){this.__barChanged=barChanged}draw(){if(null!==this.__canvasFrame&&void 0!==this.__canvasFrame)if(null!==this.__xAxis&&void 0!==this.__xAxis){if(this.getHasChanged()){null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height);let xAxisHeight=0,startValueX=null,endValueX=null;if(this.__xAxis.setMainTickStartValueOverride(null),this.__xAxis.setMainTickEndValueOverride(null),this.__xAxis.getAutoScaling()){for(let j=0,jj=this.__barGraph.length;j<jj;j++)(null===endValueX||endValueX<this.__barGraph[j].values.length-1)&&(endValueX=this.__barGraph[j].values.length-1);startValueX=0,null!==startValueX&&null!==endValueX&&(startValueX===endValueX&&(startValueX-=.5,endValueX+=.5),this.__xAxis.setMainTickStartValueOverride(startValueX),this.__xAxis.setMainTickEndValueOverride(endValueX))}if(this.__xAxis.drawAxis({x:0,y:this.__canvasFrame.height},{x:this.__canvasFrame.width,y:this.__canvasFrame.height}),xAxisHeight=this.__xAxis.getHeight(),xAxisHeight>0?xAxisHeight+=10:xAxisHeight=5,null!==this.__yAxis&&void 0!==this.__yAxis&&this.__yAxis.length>0){null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height);let widthLeft=5,widthRight=5,showOnlyYAxis=!1,biggestFirst=0,biggestLatest=0;for(let h=0,hh=this.__yAxis.length;h<hh;h++){this.__yAxis[h].setMainTickStartValueOverride(null),this.__yAxis[h].setMainTickEndValueOverride(null);let startValue=0,endValue=null;if(this.__yAxis[h].getAutoScaling())for(let j=0,jj=this.__barGraph.length;j<jj;j++){const tempLineGraph=this.__barGraph[j];if(null!==tempLineGraph.yAxis&&tempLineGraph.yAxis.getId()===this.__yAxis[h].getId()){for(let k=0,kk=this.__barGraph[j].values.length;k<kk;k++)startValue>this.__barGraph[j].values[k]&&(startValue=this.__barGraph[j].values[k]),(null===endValue||endValue<this.__barGraph[j].values[k])&&(endValue=this.__barGraph[j].values[k]);null!==startValue&&null!==endValue&&(startValue===endValue&&(startValue-=.5,endValue+=.5),this.__yAxis[h].setMainTickStartValueOverride(startValue),this.__yAxis[h].setMainTickEndValueOverride(endValue))}}let yAxis=this.__yAxis[h],labelArray=yAxis.getCalculatedLabels();if(yAxis.getShowAxis()&&yAxis.getShowLabels()){let callback=yAxis.getYAxisCallback(),mainTickSteps=yAxis.getMainTickSteps();if(null!==callback){if(void 0!==labelArray[0]&&null!==labelArray[0]){let first=yAxis.calculateLabelHeight(callback.apply(this,[parseFloat(labelArray[0])]));first>biggestFirst&&(biggestFirst=first)}if(null!==mainTickSteps&&void 0!==labelArray[mainTickSteps-1]&&null!==labelArray[mainTickSteps-1]){let latest=yAxis.calculateLabelHeight(callback.apply(this,[parseFloat(labelArray[mainTickSteps-1])]));latest>biggestLatest&&(biggestLatest=latest)}}else{if(void 0!==labelArray[0]&&null!==labelArray[0]){let first=yAxis.calculateLabelHeight(labelArray[0]);first>biggestFirst&&(biggestFirst=first)}if(null!==mainTickSteps&&void 0!==labelArray[mainTickSteps-1]&&null!==labelArray[mainTickSteps-1]){let latest=yAxis.calculateLabelHeight(labelArray[mainTickSteps-1]);latest>biggestLatest&&(biggestLatest=latest)}}}}for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__xAxis.getShowAxis()||(showOnlyYAxis=!0),this.__yAxis[i].getPosition()===TcHmiCharting.IAxis.Position.Left?(this.__yAxis[i].drawAxis({x:widthLeft,y:this.__canvasFrame.height-xAxisHeight},{x:widthLeft,y:5},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),this.__yAxis[i].getShowAxis()&&(widthLeft=widthLeft+10+this.__yAxis[i].getWidth())):(this.__yAxis[i].drawAxis({x:this.__canvasFrame.width-widthRight,y:this.__canvasFrame.height-xAxisHeight},{x:this.__canvasFrame.width-widthRight,y:5},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),this.__yAxis[i].getShowAxis()&&(widthRight=widthRight+10+this.__yAxis[i].getWidth()));this.__canvasFrame.width-widthRight-widthLeft>0?this.__xAxis.drawAxis({x:widthLeft+this.__drawingBorder.width,y:this.__canvasFrame.height},{x:this.__canvasFrame.width-widthRight-this.__drawingBorder.width,y:this.__canvasFrame.height}):this.__xAxis.drawAxis({x:0,y:0},{x:0,y:0});let barWidth,xAxisLabel=this.__xAxis.getCalculatedNumbers(),xAxisMainTickSteps=this.__xAxis.getMainTickSteps(),barWdithDrawingBorder=0;if(null===this.__barWidth)if(this.__barGraphArrangement===TcHmiCharting.BarGraph.BarGraphArrangement.Overlapped){if(this.__barGraph.length>0)if(null!==xAxisMainTickSteps&&xAxisMainTickSteps>1&&0!==xAxisLabel.length){let xCalc=this.__xAxis.getLineWidth()/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]);this.__calcBarWidth=Math.floor(Math.floor(xCalc)*(2/3)),this.__calcBarWidth<1&&(this.__calcBarWidth=1),barWdithDrawingBorder=this.__calcBarWidth}else this.__calcBarWidth=1,barWdithDrawingBorder=this.__calcBarWidth;else this.__calcBarWidth=0,barWdithDrawingBorder=this.__calcBarWidth;barWidth=this.__calcBarWidth}else{if(this.__barGraph.length>0)if(null!==xAxisMainTickSteps&&xAxisMainTickSteps>1&&0!==xAxisLabel.length){let xCalc=this.__xAxis.getLineWidth()/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]);if(this.__barGraph.length>0){let placeForAllBars=Math.floor(Math.floor(xCalc)*(2/3));barWdithDrawingBorder=placeForAllBars,this.__calcBarWidth=(placeForAllBars-2*(this.__barGraph.length-1))/this.__barGraph.length}else this.__calcBarWidth=Math.floor(Math.floor(xCalc)*(2/3)),barWdithDrawingBorder=this.__calcBarWidth;this.__calcBarWidth<1&&(this.__calcBarWidth=1,barWdithDrawingBorder=this.__calcBarWidth)}else this.__calcBarWidth=1,barWdithDrawingBorder=this.__calcBarWidth;else this.__calcBarWidth=0,barWdithDrawingBorder=this.__calcBarWidth;barWidth=this.__calcBarWidth}else barWidth=this.__barWidth,this.__barGraphArrangement===TcHmiCharting.BarGraph.BarGraphArrangement.Overlapped?barWdithDrawingBorder=this.__barWidth:(barWdithDrawingBorder=this.__barWidth,this.__barGraph.length>1&&(barWdithDrawingBorder=2*((this.__barGraph.length-1)/2*2+this.__barGraph.length/2*this.__barWidth)));let gridLineWidth=0;null!==this.__grid&&(gridLineWidth=this.__grid.getLineWidth()||0,gridLineWidth/=2),this.__drawingBorder.width=gridLineWidth>barWdithDrawingBorder/2?gridLineWidth:barWdithDrawingBorder/2,this.__drawingBorder.height=gridLineWidth>5?gridLineWidth:5,this.__drawingBorder.width<5&&(this.__drawingBorder.width=5),null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height),widthLeft=5,widthRight=5;for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].getPosition()===TcHmiCharting.IAxis.Position.Left?(this.__yAxis[i].drawAxis({x:widthLeft,y:this.__canvasFrame.height-xAxisHeight-this.__drawingBorder.height},{x:widthLeft,y:5+this.__drawingBorder.height},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),widthLeft=widthLeft+10+this.__yAxis[i].getWidth()):(this.__yAxis[i].drawAxis({x:this.__canvasFrame.width-widthRight,y:this.__canvasFrame.height-xAxisHeight-this.__drawingBorder.height},{x:this.__canvasFrame.width-widthRight,y:5+this.__drawingBorder.height},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),widthRight=widthRight+10+this.__yAxis[i].getWidth());if(this.__canvasFrame.width-widthRight-widthLeft>0?this.__xAxis.drawAxis({x:widthLeft+this.__drawingBorder.width,y:this.__canvasFrame.height},{x:this.__canvasFrame.width-widthRight-this.__drawingBorder.width,y:this.__canvasFrame.height}):this.__xAxis.drawAxis({x:0,y:0},{x:0,y:0}),null===this.__barWidth)if(this.__barGraphArrangement===TcHmiCharting.BarGraph.BarGraphArrangement.Overlapped){if(this.__barGraph.length>0)if(null!==xAxisMainTickSteps&&xAxisMainTickSteps>1&&0!==xAxisLabel.length){let xCalc=this.__xAxis.getLineWidth()/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]);this.__calcBarWidth=Math.floor(Math.floor(xCalc)*(2/3)),this.__calcBarWidth<1&&(this.__calcBarWidth=1)}else this.__calcBarWidth=1;else this.__calcBarWidth=0;barWidth=this.__calcBarWidth}else if(this.__barGraph.length>0)if(null!==xAxisMainTickSteps&&xAxisMainTickSteps>1&&0!==xAxisLabel.length){let xCalc=this.__xAxis.getLineWidth()/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]);if(this.__barGraph.length>0){let placeForAllBars=Math.floor(Math.floor(xCalc)*(2/3));this.__calcBarWidth=(placeForAllBars-2*(this.__barGraph.length-1))/this.__barGraph.length}else this.__calcBarWidth=Math.floor(Math.floor(xCalc)*(2/3));this.__calcBarWidth<1&&(this.__calcBarWidth=1)}else this.__calcBarWidth=1;else this.__calcBarWidth=0;let yAxisMainTickSteps=this.__yMainTickSteps,xAxisWidth=this.__xAxis.getAxisWidth(),yAxisWidth=this.getYAxisWidth();if(null!==xAxisMainTickSteps&&null!==yAxisMainTickSteps&&null!==xAxisWidth&&null!==yAxisWidth){let xAxisSubTickSteps=this.__xAxis.getSubTickSteps(),yAxisSubTickSteps=this.__ySubTickSteps,showGridHorizontal=!!this.__grid&&this.__grid.getShowHorizontalLines(),showGridVertical=!!this.__grid&&this.__grid.getShowVerticalLines(),showSubgridHorizontal=!!this.__subgrid&&this.__subgrid.getShowHorizontalLines(),showSubgridVertical=!!this.__subgrid&&this.__subgrid.getShowVerticalLines(),gridBackgroundColor=this.__grid?this.__grid.getBackgroundColor():null;((showGridHorizontal||showGridVertical)&&this.__grid&&null!==this.__grid.getLineColor()&&null!==this.__grid.getLineWidth()&&null!==this.__grid.getLineStyle()||(showSubgridHorizontal&&null!==yAxisSubTickSteps||showSubgridVertical&&null!==xAxisSubTickSteps)&&this.__subgrid&&null!==this.__subgrid.getLineColor()&&null!==this.__subgrid.getLineWidth()&&null!==this.__subgrid.getLineStyle())&&this.__contextFrame&&gridBackgroundColor&&(this.__contextFrame.fillStyle=gridBackgroundColor,showOnlyYAxis?this.__contextFrame.fillRect(this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder.width,this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2,this.__xAxis.getLineWidth()+2*this.__drawingBorder.width,-this.__yAxis[0].getLineHeight()-2*this.__drawingBorder.height):this.__contextFrame.fillRect(this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder.width,this.__canvasFrame.height-xAxisHeight-yAxisWidth/2,this.__xAxis.getLineWidth()+2*this.__drawingBorder.width,-this.__yAxis[0].getLineHeight()-2*this.__drawingBorder.height)),this.__subgrid&&this.__grid&&(showOnlyYAxis?this.__subgrid.draw({x:this.__xAxis.getXAxisLeftWidth(),y:this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2-this.__drawingBorder.height},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisSubTickSteps,this.__xAxis.getLineWidth()/(xAxisMainTickSteps-1),yAxisSubTickSteps,this.__yAxis[0].getLineHeight()/(yAxisMainTickSteps-1),xAxisMainTickSteps,yAxisMainTickSteps,this.__grid.getLineWidth()||0,this.__drawingBorder):this.__subgrid.draw({x:this.__xAxis.getXAxisLeftWidth(),y:this.__canvasFrame.height-xAxisHeight-yAxisWidth/2-this.__drawingBorder.height},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisSubTickSteps,this.__xAxis.getLineWidth()/(xAxisMainTickSteps-1),yAxisSubTickSteps,this.__yAxis[0].getLineHeight()/(yAxisMainTickSteps-1),xAxisMainTickSteps,yAxisMainTickSteps,this.__grid.getLineWidth()||0,this.__drawingBorder)),this.__grid&&(showOnlyYAxis?this.__grid.draw({x:this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder.width,y:this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisMainTickSteps,yAxisMainTickSteps,this.__drawingBorder):this.__grid.draw({x:this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder.width,y:this.__canvasFrame.height-xAxisHeight-yAxisWidth/2},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisMainTickSteps,yAxisMainTickSteps,this.__drawingBorder))}this.__barChanged=!0,this.__widthLeft=this.__xAxis.getXAxisLeftWidth()}}if(this.__barChanged)if(null!==this.__yAxis&&void 0!==this.__yAxis)if(this.__yAxis.length>0){null!==this.__contextDrawing&&null!==this.__canvasDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);let canvasElem=this.__elementRoot.find(".TcHmi_Controls_Beckhoff_Controls-chart-canvas-drawing")[0];for(let i=0,ii=this.__barGraph.length;i<ii;i++)if(null!==this.__barGraph[i].yAxis&&void 0!==this.__barGraph[i].yAxis){let barGraph=this.__barGraphs[i];barGraph.setCanvas(canvasElem),null===this.__barWidth?barGraph.setBarWidth(this.__calcBarWidth):barGraph.setBarWidth(this.__barWidth),barGraph.setDrawingBorder(this.__drawingBorder),this.__barGraphArrangement===TcHmiCharting.BarGraph.BarGraphArrangement.Overlapped?barGraph.draw(this.__barGraph[i],this.__xAxis):barGraph.drawClustered(this.__barGraph[i],this.__xAxis,i)}this.__barChanged=!1}else null!==this.__contextDrawing&&null!==this.__canvasDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);else null!==this.__contextDrawing&&null!==this.__canvasDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);this.setHasChanged(!1)}else null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height),null!==this.__contextDrawing&&null!==this.__canvasDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height)}}TcHmiCharting.BarChart=BarChart}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class IAxis{constructor(id,canvas){this.__showAxis=!0,this.__showLabels=!0,this.__mainTickStartValue=null,this.__mainTickSteps=null,this.__mainTickEndValue=null,this.__subTickSteps=null,this.__showSubTicks=!0,this.__mainTickStartValueOverride=null,this.__mainTickEndValueOverride=null,this.__labelFontFamily=null,this.__labelFontSize=null,this.__labelFontSizeUnit="px",this.__labelFontWeight=null,this.__labelFontColor=null,this.__axisWidth=null,this.__axisColor=null,this.__showAxisName=!0,this.__axisName=null,this.__axisNameFontFamily=null,this.__axisNameFontSize=null,this.__axisNameFontSizeUnit="px",this.__axisNameFontWeight=null,this.__axisNameFontColor=null,this.__decimalPlaces=null,this.__unit=null,this.__autoScaling=!1,this.__canvas=canvas,this.__context=this.__canvas.getContext("2d"),this.__id=id}getCalculatedLabels(){let labelArray=[];if(null!==this.__mainTickSteps)if(this.__autoScaling){if(1===this.__mainTickSteps){if(null!==this.__mainTickStartValueOverride&&null!==this.__decimalPlaces){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round(this.__mainTickStartValueOverride*multiplier)/multiplier;return""!==this.__unit&&null!==this.__unit&&void 0!==this.__unit?labelArray.push(roundedValue+" "+this.__unit):labelArray.push(roundedValue.toString()),labelArray}if(null!==this.__mainTickStartValue&&null!==this.__decimalPlaces){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round(this.__mainTickStartValue*multiplier)/multiplier;return""!==this.__unit&&null!==this.__unit&&void 0!==this.__unit?labelArray.push(roundedValue+" "+this.__unit):labelArray.push(roundedValue.toString()),labelArray}}else if(this.__mainTickSteps>0){if(null!==this.__mainTickEndValueOverride&&null!==this.__mainTickStartValueOverride&&null!==this.__decimalPlaces){let mainTickWidth=Math.abs(this.__mainTickStartValueOverride-this.__mainTickEndValueOverride)/(this.__mainTickSteps-1);for(let i=0;i<=this.__mainTickSteps-1;i++){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round((i*mainTickWidth+this.__mainTickStartValueOverride)*multiplier)/multiplier;""!==this.__unit&&null!==this.__unit&&void 0!==this.__unit?labelArray.push(roundedValue+" "+this.__unit):labelArray.push(roundedValue.toString())}return labelArray}if(null!==this.__mainTickStartValue&&null!==this.__mainTickEndValue&&null!==this.__decimalPlaces){let mainTickWidth=Math.abs(this.__mainTickStartValue-this.__mainTickEndValue)/(this.__mainTickSteps-1);for(let i=0;i<=this.__mainTickSteps-1;i++){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round((i*mainTickWidth+this.__mainTickStartValue)*multiplier)/multiplier;""!==this.__unit&&null!==this.__unit&&void 0!==this.__unit?labelArray.push(roundedValue+" "+this.__unit):labelArray.push(roundedValue.toString())}return labelArray}}}else if(1===this.__mainTickSteps){if(null!==this.__mainTickStartValue&&null!==this.__decimalPlaces){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round(this.__mainTickStartValue*multiplier)/multiplier;return""!==this.__unit&&null!==this.__unit&&void 0!==this.__unit?labelArray.push(roundedValue+" "+this.__unit):labelArray.push(roundedValue.toString()),labelArray}}else if(this.__mainTickSteps>0&&null!==this.__mainTickStartValue&&null!==this.__mainTickEndValue&&null!==this.__decimalPlaces){let mainTickWidth=Math.abs(this.__mainTickStartValue-this.__mainTickEndValue)/(this.__mainTickSteps-1);for(let i=0;i<=this.__mainTickSteps-1;i++){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round((i*mainTickWidth+this.__mainTickStartValue)*multiplier)/multiplier;""!==this.__unit&&null!==this.__unit&&void 0!==this.__unit?labelArray.push(roundedValue+" "+this.__unit):labelArray.push(roundedValue.toString())}return labelArray}return labelArray}getCalculatedNumbers(){let labelArray=[];if(null!==this.__mainTickSteps){if(this.__autoScaling){if(1===this.__mainTickSteps){if(null!==this.__mainTickStartValueOverride&&null!==this.__decimalPlaces){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round(this.__mainTickStartValueOverride*multiplier)/multiplier;labelArray.push(roundedValue)}else if(null!==this.__mainTickStartValue&&null!==this.__decimalPlaces){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round(this.__mainTickStartValue*multiplier)/multiplier;labelArray.push(roundedValue)}}else if(this.__mainTickSteps>0)if(null!==this.__mainTickEndValueOverride&&null!==this.__mainTickStartValueOverride&&null!==this.__decimalPlaces){let mainTickWidth=Math.abs(this.__mainTickStartValueOverride-this.__mainTickEndValueOverride)/(this.__mainTickSteps-1);for(let i=0;i<=this.__mainTickSteps-1;i++){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round((i*mainTickWidth+this.__mainTickStartValueOverride)*multiplier)/multiplier;labelArray.push(roundedValue)}}else if(null!==this.__mainTickStartValue&&null!==this.__mainTickEndValue&&null!==this.__decimalPlaces){let mainTickWidth=Math.abs(this.__mainTickStartValue-this.__mainTickEndValue)/(this.__mainTickSteps-1);for(let i=0;i<=this.__mainTickSteps-1;i++){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round((i*mainTickWidth+this.__mainTickStartValue)*multiplier)/multiplier;labelArray.push(roundedValue)}}return labelArray}if(1===this.__mainTickSteps){if(null!==this.__mainTickStartValue&&null!==this.__decimalPlaces){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round(this.__mainTickStartValue*multiplier)/multiplier;labelArray.push(roundedValue)}}else if(this.__mainTickSteps>0&&null!==this.__mainTickStartValue&&null!==this.__mainTickEndValue&&null!==this.__decimalPlaces){let mainTickWidth=Math.abs(this.__mainTickStartValue-this.__mainTickEndValue)/(this.__mainTickSteps-1);for(let i=0;i<=this.__mainTickSteps-1;i++){let multiplier=Math.pow(10,this.__decimalPlaces),roundedValue=Math.round((i*mainTickWidth+this.__mainTickStartValue)*multiplier)/multiplier;labelArray.push(roundedValue)}}return labelArray}return labelArray}calculateLabelWidth(label){let cxt=this.__canvas.getContext("2d");if(null!==cxt&&label&&null!==this.__labelFontWeight&&null!==this.__labelFontSize&&null!==this.__labelFontFamily){return cxt.font=this.__labelFontWeight+" "+this.__labelFontSize+this.__labelFontSizeUnit+" "+this.__labelFontFamily,cxt.measureText(label).width}return 0}getLongestTextWidth(){let labelArray=this.getCalculatedLabels(),width=0,cxt=this.__canvas.getContext("2d");if(null!==cxt){if(null!==this.__labelFontWeight&&null!==this.__labelFontSize&&null!==this.__labelFontFamily){cxt.font=this.__labelFontWeight+" "+this.__labelFontSize+this.__labelFontSizeUnit+" "+this.__labelFontFamily;for(let i=0;i<=labelArray.length-1;i++){let metrics=cxt.measureText(labelArray[i]);metrics.width>width&&(width=metrics.width)}}return labelArray.splice(0,labelArray.length),width}return 0}calculateLabelHeight(content){return null!==this.__labelFontSize?1.2*this.__labelFontSize:0}calculateAxisNameHeight(content){return null!==this.__axisNameFontSize?1.2*this.__axisNameFontSize:0}calculateAxisNameWidth(content){let cxt=this.__canvas.getContext("2d");if(null!==cxt&&null!==this.__axisNameFontWeight&&null!==this.__axisNameFontSize&&null!==this.__axisNameFontSizeUnit&&null!==this.__axisNameFontFamily){return cxt.font=this.__axisNameFontWeight+" "+this.__axisNameFontSize+this.__axisNameFontSizeUnit+" "+this.__axisNameFontFamily,cxt.measureText(content).width}return 0}getId(){return this.__id}setShowLabels(showLabels){this.__showLabels=showLabels}setShowAxis(showAxis){this.__showAxis=showAxis}getShowAxis(){return this.__showAxis}getShowLabels(){return this.__showLabels}setShowSubTicks(showSubTicks){this.__showSubTicks=showSubTicks}getShowSubTicks(){return this.__showSubTicks}setMainTickStartValue(mainTickStartValue){this.__mainTickStartValue=mainTickStartValue}getMainTickStartValue(){return this.__mainTickStartValue}setMainTickSteps(mainTickSteps){this.__mainTickSteps=mainTickSteps}getMainTickSteps(){return this.__mainTickSteps}setMainTickEndValue(mainTickEndValue){this.__mainTickEndValue=mainTickEndValue}getMainTickEndValue(){return this.__mainTickEndValue}setSubTickSteps(subTickSteps){this.__subTickSteps=subTickSteps}getSubTickSteps(){return this.__subTickSteps}setLabelFontFamily(labelFontFamily){if(labelFontFamily)this.__labelFontFamily=labelFontFamily;else{const inheritedFontfamily=TcHmi.StyleProvider.getComputedElementStyle(this.__canvas,"font-family")["font-family"];this.__labelFontFamily=inheritedFontfamily||null}}getLabelFontFamily(){return this.__labelFontFamily}setLabelFontSize(labelFontSize){if(labelFontSize)this.__labelFontSize=labelFontSize;else{const inheritedFontSize=TcHmi.StyleProvider.getComputedElementStyle(this.__canvas,"font-size")["font-size"];this.__labelFontSize=inheritedFontSize?parseFloat(inheritedFontSize):null}}getLabelFontSize(){return this.__labelFontSize}setLabelFontSizeUnit(labelFontSizeUnit){}getLabelFontSizeUnit(){return this.__labelFontSizeUnit}setLabelFontWeight(labelFontWeight){if(labelFontWeight&&"Auto"!==labelFontWeight)this.__labelFontWeight=labelFontWeight;else{const inheritedFontWeight=TcHmi.StyleProvider.getComputedElementStyle(this.__canvas,"font-weight")["font-weight"];this.__labelFontWeight=inheritedFontWeight||null}}getLabelFontWeight(){return this.__labelFontWeight}setLabelFontColor(labelFontColor){this.__labelFontColor=labelFontColor}getLabelFontColor(){return this.__labelFontColor}setShowAxisName(showAxisName){this.__showAxisName=showAxisName}getShowAxisName(){return this.__showAxisName}setAxisWidth(axisWidth){this.__axisWidth=axisWidth}getAxisWidth(){return this.__axisWidth}setAxisColor(axisColor){this.__axisColor=axisColor}getAxisColor(){return this.__axisColor}getAxisName(){return this.__axisName}setAxisNameFontFamily(axisNameFontFamily){if(axisNameFontFamily)this.__axisNameFontFamily=axisNameFontFamily;else{const inheritedFontfamily=TcHmi.StyleProvider.getComputedElementStyle(this.__canvas,"font-family")["font-family"];this.__axisNameFontFamily=inheritedFontfamily||null}}getAxisNameFontFamily(){return this.__axisNameFontFamily}setAxisNameFontSize(axisNameFontSize){if(axisNameFontSize)this.__axisNameFontSize=axisNameFontSize;else{const inheritedFontSize=TcHmi.StyleProvider.getComputedElementStyle(this.__canvas,"font-size")["font-size"];this.__axisNameFontSize=inheritedFontSize?parseFloat(inheritedFontSize):null}}getAxisNameFontSize(){return this.__axisNameFontSize}setAxisNameFontSizeUnit(axisNameFontSizeUnit){}getAxisNameFontSizeUnit(){return this.__axisNameFontSizeUnit}setAxisNameFontWeight(axisNameFontWeight){if(axisNameFontWeight&&"Auto"!==axisNameFontWeight)this.__axisNameFontWeight=axisNameFontWeight;else{const inheritedFontWeight=TcHmi.StyleProvider.getComputedElementStyle(this.__canvas,"font-weight")["font-weight"];this.__axisNameFontWeight=inheritedFontWeight||null}}getAxisNameFontWeight(){return this.__axisNameFontWeight}setAxisNameFontColor(axisNameFontColor){this.__axisNameFontColor=axisNameFontColor}getAxisNameFontColor(){return this.__axisNameFontColor}setDecimalPlaces(decimalPlaces){this.__decimalPlaces=decimalPlaces}getDecimalPlaces(){return this.__decimalPlaces}setUnit(unit){this.__unit=unit}getUnit(){return this.__unit}setAutoScaling(autoScaling){this.__autoScaling=autoScaling}getAutoScaling(){return this.__autoScaling}setMainTickStartValueOverride(mainTickStartValueOverride){this.__mainTickStartValueOverride=mainTickStartValueOverride}getMainTickStartValueOverride(){return this.__mainTickStartValueOverride}setMainTickEndValueOverride(mainTickEndValueOverride){this.__mainTickEndValueOverride=mainTickEndValueOverride}getMainTickEndValueOverride(){return this.__mainTickEndValueOverride}}TcHmiCharting.IAxis=IAxis,function(IAxis){let Position;!function(Position){Position[Position.Left=0]="Left",Position[Position.Right=1]="Right"}(Position=IAxis.Position||(IAxis.Position={}))}(IAxis=TcHmiCharting.IAxis||(TcHmiCharting.IAxis={}))}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class XAxis extends TcHmiCharting.IAxis{constructor(id,canvas){super(id,canvas),this.__width=0,this.__height=0,this.__lineWidth=0,this.__diffStartLabelAndLine=0,this.__diffEndLabelAndLine=0,this.__xAxisCallback=null,this.__xAxisLeftWidth=0}drawAxis(startPoint,endPoint){if(null!==this.__axisWidth&&null!==this.__axisColor){startPoint.x=startPoint.x+this.__axisWidth/2,endPoint.x=endPoint.x-this.__axisWidth/2;let beginX=startPoint.x,beginY=startPoint.y,endX=endPoint.x,mainTickLength=10+this.__axisWidth/2,subTickLength=5+this.__axisWidth/2,startPixelDiffBetweenMain=0;if(null!==this.__mainTickSteps){this.__mainTickSteps>0&&(startPixelDiffBetweenMain=(endPoint.x-startPoint.x)/(this.__mainTickSteps-1));let subTickSteps=0;null!==this.__subTickSteps&&(subTickSteps=this.__subTickSteps);let pixelDiffBetweenMain=startPixelDiffBetweenMain,pixelDiffBetweenSub=pixelDiffBetweenMain/(subTickSteps+1),labelArray=this.getCalculatedLabels(),leftWidth=0;null!==this.__xAxisCallback?this.__showLabels&&void 0!==labelArray[0]&&null!==labelArray[0]&&(leftWidth=this.calculateLabelWidth(this.__xAxisCallback.apply(this,[parseFloat(labelArray[0])]))):this.__showLabels&&void 0!==labelArray[0]&&null!==labelArray[0]&&(leftWidth=this.calculateLabelWidth(labelArray[0]));let rightWidth=0;if(null!==this.__xAxisCallback?this.__showLabels&&void 0!==labelArray[labelArray.length-1]&&null!==labelArray[labelArray.length-1]&&(rightWidth=this.calculateLabelWidth(this.__xAxisCallback.apply(this,[parseFloat(labelArray[labelArray.length-1])]))):this.__showLabels&&void 0!==labelArray[labelArray.length-1]&&null!==labelArray[labelArray.length-1]&&(rightWidth=this.calculateLabelWidth(labelArray[labelArray.length-1])),this.__axisWidth<leftWidth){if(startPoint.x<leftWidth/2&&this.__showAxis){let diff=Math.abs(startPoint.x-this.__axisWidth/2-leftWidth/2);startPoint.x=startPoint.x+diff+5}beginX=startPoint.x}if(this.__xAxisLeftWidth=startPoint.x,this.__axisWidth<rightWidth){let right=this.__canvas.width-endPoint.x;if(right<rightWidth/2&&this.__showAxis){let diff=Math.abs(right+this.__axisWidth/2-rightWidth/2);endPoint.x=endPoint.x-diff-5}endX=endPoint.x}startPixelDiffBetweenMain=(endPoint.x-startPoint.x)/(this.__mainTickSteps-1),pixelDiffBetweenMain=startPixelDiffBetweenMain,pixelDiffBetweenSub=pixelDiffBetweenMain/(subTickSteps+1);let height=0;if(this.__showAxisName&&null!==this.__axisName&&(height=this.calculateAxisNameHeight(this.__axisName),this.__showAxis&&null!==this.__context&&null!==this.__axisNameFontWeight&&null!==this.__axisNameFontSize&&null!==this.__axisNameFontFamily&&null!==this.__axisNameFontColor&&(this.__context.font=this.__axisNameFontWeight+" "+this.__axisNameFontSize+this.__axisNameFontSizeUnit+" "+this.__axisNameFontFamily,this.__context.fillStyle=this.__axisNameFontColor,this.__context.textAlign="center",this.__context.beginPath(),this.__context.fillText(this.__axisName,startPoint.x+(endPoint.x-startPoint.x)/2,startPoint.y),this.__context.stroke()),height+=3),this.__showLabels&&this.__mainTickSteps>0&&labelArray.length>0){if(null!==this.__labelFontSize){let highestLabel=1.2*this.__labelFontSize;startPoint.y=startPoint.y-highestLabel/2-height;let xPoint=startPoint.x,yPoint=startPoint.y;if(null!==this.__context&&this.__showAxis&&null!==this.__labelFontWeight&&null!==this.__labelFontSize&&null!==this.__labelFontFamily&&null!==this.__labelFontColor){for(let i=0;i<=this.__mainTickSteps-1;i++){if(this.__context.font=this.__labelFontWeight+" "+this.__labelFontSize+this.__labelFontSizeUnit+" "+this.__labelFontFamily,this.__context.fillStyle=this.__labelFontColor,this.__context.textAlign="center",this.__context.textBaseline="alphabetic",this.__context.beginPath(),null!==this.__xAxisCallback){let formattedValue=this.__xAxisCallback.apply(this,[parseFloat(labelArray[i])]);null===formattedValue&&(formattedValue=""),this.__context.fillText(formattedValue,xPoint,yPoint)}else this.__context.fillText(labelArray[i],xPoint,yPoint);xPoint+=pixelDiffBetweenMain}this.__context.stroke()}startPoint.y=startPoint.y-highestLabel/2-5}}else startPoint.y=startPoint.y-5-height;if(this.__mainTickSteps>0&&this.__showAxis&&null!==this.__context){this.__context.strokeStyle=this.__axisColor,this.__context.lineWidth=this.__axisWidth,this.__context.setLineDash([]),this.__context.beginPath();for(let i=0;i<=this.__mainTickSteps-1;i++)if(0===i?(this.__context.moveTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),0|startPoint.y),this.__context.lineTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),(startPoint.y-mainTickLength|0)+(this.__axisWidth%2==0?0:.5))):i===this.__mainTickSteps?(startPoint.x=startPoint.x+pixelDiffBetweenMain,this.__context.lineTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),(startPoint.y-mainTickLength|0)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),0|startPoint.y)):(startPoint.x=startPoint.x+pixelDiffBetweenMain,this.__context.lineTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),(startPoint.y-mainTickLength|0)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),0|startPoint.y),this.__context.moveTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),(startPoint.y-mainTickLength|0)+(this.__axisWidth%2==0?0:.5))),pixelDiffBetweenMain=startPixelDiffBetweenMain,i<=this.__mainTickSteps-2&&0!==this.__subTickSteps&&this.__showSubTicks&&null!==this.__subTickSteps)for(let j=0;j<=this.__subTickSteps-1;j++)startPoint.x=startPoint.x+pixelDiffBetweenSub,this.__context.lineTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),(startPoint.y-mainTickLength|0)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),startPoint.y-(mainTickLength-subTickLength)|0),this.__context.moveTo((0|startPoint.x)+(this.__axisWidth%2==0?0:.5),(startPoint.y-mainTickLength|0)+(this.__axisWidth%2==0?0:.5)),pixelDiffBetweenMain-=pixelDiffBetweenSub;this.__context.stroke()}if(this.__diffStartLabelAndLine=0,this.__diffEndLabelAndLine=0,this.__showLabels)if(this.__mainTickSteps>0){let calculatedLabelWidthStart=0;calculatedLabelWidthStart=null!==this.__xAxisCallback?this.calculateLabelWidth(this.__xAxisCallback.apply(this,[parseFloat(labelArray[0])])):this.calculateLabelWidth(labelArray[0]),this.__axisWidth<calculatedLabelWidthStart&&(this.__diffStartLabelAndLine=calculatedLabelWidthStart/2-this.__axisWidth/2);let calculatedLabelWidthEnd=0;calculatedLabelWidthEnd=null!==this.__xAxisCallback?this.calculateLabelWidth(this.__xAxisCallback.apply(this,[parseFloat(labelArray[labelArray.length-1])])):this.calculateLabelWidth(labelArray[labelArray.length-1]),this.__axisWidth<calculatedLabelWidthEnd&&(this.__diffEndLabelAndLine=calculatedLabelWidthEnd/2-this.__axisWidth/2)}else this.__height=height;this.__width=endX-beginX+this.__diffStartLabelAndLine+this.__diffEndLabelAndLine,this.__height=beginY-(startPoint.y-mainTickLength)+this.__axisWidth/2,this.__lineWidth=endX-beginX,this.__lineWidth<0&&(this.__lineWidth=0),this.__width<0&&(this.__width=0),this.__height<0&&(this.__height=0),this.__showAxis||(this.__height=0),labelArray.splice(0,labelArray.length)}}}setAxisName(axisName){this.__axisName=axisName}getHeight(){return this.__height}getWidth(){return this.__width}getLineWidth(){return this.__lineWidth}getDiffStartLabelAndLine(){return this.__diffStartLabelAndLine}getDiffEndLabelAndLine(){return this.__diffEndLabelAndLine}setXAxisCallback(callback){this.__xAxisCallback=callback}getXAxisCallback(){return this.__xAxisCallback}getXAxisLeftWidth(){return this.__xAxisLeftWidth}}TcHmiCharting.XAxis=XAxis}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class YAxis extends TcHmiCharting.IAxis{constructor(id,canvas,position){super(id,canvas),this.__width=0,this.__height=0,this.__lineHeight=0,this.__diffStartLabelAndLine=0,this.__diffEndLabelAndLine=0,this.__yAxisCallback=null,this.__position=position}drawAxis(startPoint,endPoint,showOnlyYAxis,labelSize){if(null!==this.__axisWidth&&null!==this.__axisColor){startPoint.y=startPoint.y-this.__axisWidth/2,endPoint.y=endPoint.y+this.__axisWidth/2;startPoint.x;let beginY=startPoint.y,endY=endPoint.y,mainTickLength=10+this.__axisWidth/2,subTickLength=5+this.__axisWidth/2,startPixelDiffBetweenMain=0;if(null!==this.__mainTickSteps){this.__mainTickSteps>0&&(startPixelDiffBetweenMain=(startPoint.y-endPoint.y)/(this.__mainTickSteps-1));let subTickSteps=0;null!==this.__subTickSteps&&(subTickSteps=this.__subTickSteps);let pixelDiffBetweenMain=startPixelDiffBetweenMain,pixelDiffBetweenSub=pixelDiffBetweenMain/(subTickSteps+1),labelArray=this.getCalculatedLabels(),longestLabelWidth=this.getLongestTextWidth(),height=0;if(showOnlyYAxis&&this.__axisWidth<labelSize.first&&(startPoint.y=startPoint.y-(labelSize.first/2-this.__axisWidth/2)),this.__axisWidth<labelSize.latest&&(endPoint.y=endPoint.y+(labelSize.latest/2-this.__axisWidth/2)),startPixelDiffBetweenMain=(startPoint.y-endPoint.y)/(this.__mainTickSteps-1),pixelDiffBetweenMain=startPixelDiffBetweenMain,pixelDiffBetweenSub=pixelDiffBetweenMain/(subTickSteps+1),this.__position===YAxis.Position.Left){if(this.__showAxisName&&null!==this.__axisName&&(height=this.calculateAxisNameHeight(this.__axisName),this.__showAxis&&null!==this.__context&&null!==this.__axisNameFontWeight&&null!==this.__axisNameFontSize&&null!==this.__axisNameFontFamily&&null!==this.__axisNameFontColor&&(this.__context.save(),this.__context.font=this.__axisNameFontWeight+" "+this.__axisNameFontSize+this.__axisNameFontSizeUnit+" "+this.__axisNameFontFamily,this.__context.fillStyle=this.__axisNameFontColor,this.__context.beginPath(),this.__context.textAlign="center",this.__context.textBaseline="middle",this.__context.translate(startPoint.x+height/2,startPoint.y-(startPoint.y-endPoint.y)/2),this.__context.rotate(-.5*Math.PI),this.__context.fillText(this.__axisName,0,0),this.__context.stroke(),this.__context.restore()),height+=3),this.__showLabels&&this.__mainTickSteps>0&&labelArray.length>0){let yPoint=startPoint.y;if(this.__axisWidth<labelSize.latest?yPoint+=labelSize.latest/2:yPoint=this.__axisWidth/2<labelSize.latest?yPoint+Math.abs(this.__axisWidth/2-labelSize.latest)+(this.__axisWidth-labelSize.latest)/2:yPoint+(this.__axisWidth-labelSize.latest)/2-labelSize.latest/2,null!==this.__context&&this.__showAxis&&null!==this.__labelFontWeight&&null!==this.__labelFontSize&&null!==this.__labelFontFamily&&null!==this.__labelFontColor){for(let i=0;i<=this.__mainTickSteps-1;i++){if(0!==i&&(yPoint-=pixelDiffBetweenMain),null!==this.__yAxisCallback){let formattedValue=this.__yAxisCallback.apply(this,[parseFloat(labelArray[i])]);null===formattedValue&&(formattedValue=""),labelArray[i]=formattedValue}let xPoint=startPoint.x+(longestLabelWidth-this.calculateLabelWidth(labelArray[i]))+height;this.__context.font=this.__labelFontWeight+" "+this.__labelFontSize+this.__labelFontSizeUnit+" "+this.__labelFontFamily,this.__context.fillStyle=this.__labelFontColor,this.__context.textAlign="left",this.__context.textBaseline="bottom",this.__context.beginPath(),this.__context.fillText(labelArray[i],xPoint,yPoint)}this.__context.stroke()}}else longestLabelWidth=-5;if(this.__mainTickSteps>0&&null!==this.__context&&this.__showAxis){this.__context.strokeStyle=this.__axisColor,this.__context.lineWidth=this.__axisWidth,this.__context.setLineDash([]),this.__context.beginPath();for(let i=0;i<=this.__mainTickSteps-1;i++)if(0===i?(this.__context.moveTo(startPoint.x+(longestLabelWidth+5)+height|0,(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo((startPoint.x+(longestLabelWidth+5)+height+mainTickLength|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5))):i===this.__mainTickSteps?(startPoint.y=startPoint.y-pixelDiffBetweenMain,this.__context.lineTo((startPoint.x+(longestLabelWidth+5)+mainTickLength+height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo(startPoint.x+(longestLabelWidth+5)+height|0,(0|startPoint.y)+(this.__axisWidth%2==0?0:.5))):(startPoint.y=startPoint.y-pixelDiffBetweenMain,this.__context.lineTo((startPoint.x+(longestLabelWidth+5)+mainTickLength+height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo(startPoint.x+(longestLabelWidth+5)+height|0,(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.moveTo((startPoint.x+(longestLabelWidth+5)+mainTickLength+height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5))),pixelDiffBetweenMain=startPixelDiffBetweenMain,i<=this.__mainTickSteps-2&&0!==this.__subTickSteps&&this.__showSubTicks&&null!==this.__subTickSteps)for(let j=0;j<=this.__subTickSteps-1;j++)startPoint.y=startPoint.y-pixelDiffBetweenSub,this.__context.lineTo((startPoint.x+(longestLabelWidth+5)+mainTickLength+height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo(startPoint.x+(longestLabelWidth+5)+(mainTickLength-subTickLength)+height|0,(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.moveTo((startPoint.x+(longestLabelWidth+5)+mainTickLength+height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),pixelDiffBetweenMain-=pixelDiffBetweenSub;this.__context.stroke()}}else{if(this.__showAxisName&&null!==this.__axisName&&(height=this.calculateAxisNameHeight(this.__axisName),this.__showAxis&&null!==this.__context&&null!==this.__axisNameFontWeight&&null!==this.__axisNameFontSize&&null!==this.__axisNameFontFamily&&null!==this.__axisNameFontColor&&(this.__context.save(),this.__context.font=this.__axisNameFontWeight+" "+this.__axisNameFontSize+this.__axisNameFontSizeUnit+" "+this.__axisNameFontFamily,this.__context.fillStyle=this.__axisNameFontColor,this.__context.beginPath(),this.__context.textAlign="center",this.__context.textBaseline="middle",this.__context.translate(startPoint.x-height/2,startPoint.y-(startPoint.y-endPoint.y)/2),this.__context.rotate(-.5*Math.PI),this.__context.fillText(this.__axisName,0,0),this.__context.stroke(),this.__context.restore()),height+=3),this.__showLabels&&this.__mainTickSteps>0&&labelArray.length>0){let yPoint=startPoint.y;if(this.__axisWidth<labelSize.latest?yPoint+=labelSize.latest/2:yPoint=this.__axisWidth/2<labelSize.latest?yPoint+Math.abs(this.__axisWidth/2-labelSize.latest)+(this.__axisWidth-labelSize.latest)/2:yPoint+(this.__axisWidth-labelSize.latest)/2-labelSize.latest/2,null!==this.__context&&this.__showAxis&&null!==this.__labelFontWeight&&null!==this.__labelFontSize&&null!==this.__labelFontFamily&&null!==this.__labelFontColor){for(let i=0;i<=this.__mainTickSteps-1;i++){if(0!==i&&(yPoint-=pixelDiffBetweenMain),null!==this.__yAxisCallback){let formattedValue=this.__yAxisCallback.apply(this,[parseFloat(labelArray[i])]);null===formattedValue&&(formattedValue=""),labelArray[i]=formattedValue}let xPoint=startPoint.x-longestLabelWidth-height;this.__context.font=this.__labelFontWeight+" "+this.__labelFontSize+this.__labelFontSizeUnit+" "+this.__labelFontFamily,this.__context.fillStyle=this.__labelFontColor,this.__context.textAlign="left",this.__context.textBaseline="bottom",this.__context.beginPath(),this.__context.fillText(labelArray[i],xPoint,yPoint)}this.__context.stroke()}}else longestLabelWidth=0;let diffLineAndText=0;if(this.__showLabels&&(diffLineAndText=-5),this.__mainTickSteps>0&&null!==this.__context&&this.__showAxis){this.__context.strokeStyle=this.__axisColor,this.__context.lineWidth=this.__axisWidth,this.__context.setLineDash([]),this.__context.beginPath();for(let i=0;i<=this.__mainTickSteps-1;i++)if(0===i?(this.__context.moveTo(startPoint.x-longestLabelWidth+diffLineAndText-height|0,(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo((startPoint.x-longestLabelWidth+diffLineAndText-mainTickLength-height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5))):i===this.__mainTickSteps?(startPoint.y=startPoint.y-pixelDiffBetweenMain,this.__context.lineTo((startPoint.x-longestLabelWidth+diffLineAndText-mainTickLength-height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo(startPoint.x-longestLabelWidth+diffLineAndText-height|0,(0|startPoint.y)+(this.__axisWidth%2==0?0:.5))):(startPoint.y=startPoint.y-pixelDiffBetweenMain,this.__context.lineTo((startPoint.x-longestLabelWidth+diffLineAndText-mainTickLength-height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo(startPoint.x-longestLabelWidth+diffLineAndText-height|0,(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.moveTo((startPoint.x-longestLabelWidth+diffLineAndText-mainTickLength-height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5))),pixelDiffBetweenMain=startPixelDiffBetweenMain,i<=this.__mainTickSteps-2&&0!==this.__subTickSteps&&this.__showSubTicks&&null!==this.__subTickSteps)for(let j=0;j<=this.__subTickSteps-1;j++)startPoint.y=startPoint.y-pixelDiffBetweenSub,this.__context.lineTo((startPoint.x-longestLabelWidth+diffLineAndText-mainTickLength-height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.lineTo(startPoint.x-longestLabelWidth+diffLineAndText-(mainTickLength-subTickLength)-height|0,(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),this.__context.moveTo((startPoint.x-longestLabelWidth+diffLineAndText-mainTickLength-height|0)+(this.__axisWidth%2==0?0:.5),(0|startPoint.y)+(this.__axisWidth%2==0?0:.5)),pixelDiffBetweenMain-=pixelDiffBetweenSub;this.__context.stroke()}}this.__height=beginY-endY,this.__diffStartLabelAndLine=0,this.__diffEndLabelAndLine=0,this.__mainTickSteps>0?(this.__width=longestLabelWidth+5+mainTickLength+this.__axisWidth/2+height,this.__axisWidth<labelSize.first&&(this.__diffStartLabelAndLine=labelSize.first/2-this.__axisWidth/2),this.__axisWidth<labelSize.latest&&(this.__diffEndLabelAndLine=labelSize.latest/2-this.__axisWidth/2)):this.__width=height,this.__lineHeight=showOnlyYAxis?beginY-endY-this.__diffEndLabelAndLine-this.__diffStartLabelAndLine:beginY-endY-this.__diffEndLabelAndLine,this.__lineHeight<0&&(this.__lineHeight=0),this.__width<0&&(this.__width=0),this.__height<0&&(this.__height=0),this.__showAxis||(this.__width=0),labelArray.splice(0,labelArray.length)}}}setPosition(position){this.__position=position}getPosition(){return this.__position}setAxisName(axisName){this.__axisName=axisName}getHeight(){return this.__height}getWidth(){return this.__width}getLineHeight(){return this.__lineHeight}getDiffStartLabelAndLine(){return this.__diffStartLabelAndLine}getDiffEndLabelAndLine(){return this.__diffEndLabelAndLine}setYAxisCallback(callback){this.__yAxisCallback=callback}getYAxisCallback(){return this.__yAxisCallback}}TcHmiCharting.YAxis=YAxis}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class IGrid{constructor(canvas){this.__showHorizontalLines=!0,this.__showVerticalLines=!0,this.__lineWidth=null,this.__lineColor=null,this.__lineStyle=null,this.__backgroundColor=null,this.__context=null,this.__canvas=canvas,this.__context=canvas.getContext("2d")}setLineWidth(lineWidth){this.__lineWidth=null===lineWidth||lineWidth<=0?null:lineWidth}getLineWidth(){return this.__lineWidth}setBackgroundColor(backgroundColor){this.__backgroundColor=backgroundColor}getBackgroundColor(){return this.__backgroundColor}setLineColor(lineColor){this.__lineColor=lineColor}getLineColor(){return this.__lineColor}setLineStyle(lineStyle){this.__lineStyle=lineStyle}getLineStyle(){return this.__lineStyle}setShowVerticalLines(showVerticalLines){this.__showVerticalLines=showVerticalLines}getShowVerticalLines(){return this.__showVerticalLines}setShowHorizontalLines(showHorizontalLines){this.__showHorizontalLines=showHorizontalLines}getShowHorizontalLines(){return this.__showHorizontalLines}}TcHmiCharting.IGrid=IGrid,function(IGrid){let LineStyle;!function(LineStyle){LineStyle[LineStyle.Dotted=0]="Dotted",LineStyle[LineStyle.Dashed=1]="Dashed",LineStyle[LineStyle.Solid=2]="Solid"}(LineStyle=IGrid.LineStyle||(IGrid.LineStyle={}))}(IGrid=TcHmiCharting.IGrid||(TcHmiCharting.IGrid={}))}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class Grid extends TcHmiCharting.IGrid{constructor(canvas){super(canvas)}draw(startPoint,width,height,numberOfWidthLines,numberOfHeightLines,drawingBorder){if(null!==this.__context){if(null===this.__lineColor||null===this.__lineWidth)return;if(startPoint.x=startPoint.x+drawingBorder.width,startPoint.y=startPoint.y-drawingBorder.height,this.__context.beginPath(),this.__context.strokeStyle=this.__lineColor,this.__context.lineWidth=this.__lineWidth,this.__lineStyle){if(TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Solid?(this.__context.setLineDash([]),this.__context.lineCap="butt"):TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Dashed?(this.__context.lineCap="butt",1!==this.__lineWidth?this.__context.setLineDash([this.__lineWidth,this.__lineWidth]):this.__context.setLineDash([this.__lineWidth,2])):TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Dotted&&(this.__context.lineCap="round",this.__context.setLineDash([1,2*this.__lineWidth])),this.__showVerticalLines){let yStart=startPoint.y;if(TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Dotted&&(yStart-=this.__lineWidth/2),1===numberOfWidthLines)this.__context.moveTo((0|startPoint.x)+(this.__lineWidth%2==0?0:.5),(yStart+(this.__lineWidth/2|0)|0)-(this.__lineWidth%2==0?0:.5)),this.__context.lineTo((0|startPoint.x)+(this.__lineWidth%2==0?0:.5),(yStart-height+(this.__lineWidth/2|0)|0)-(this.__lineWidth%2==0?0:.5));else{let xDiff=width/(numberOfWidthLines-1);for(let i=0;i<numberOfWidthLines;i++)this.__context.moveTo((startPoint.x+i*xDiff|0)+(this.__lineWidth%2==0?0:.5),(yStart+(this.__lineWidth/2|0)|0)-(this.__lineWidth%2==0?0:.5)),this.__context.lineTo((startPoint.x+i*xDiff|0)+(this.__lineWidth%2==0?0:.5),(yStart-height+(this.__lineWidth/2|0)|0)-(this.__lineWidth%2==0?0:.5))}}if(this.__showHorizontalLines)if(TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Dotted&&(startPoint.x=startPoint.x+this.__lineWidth/2,width-=this.__lineWidth),1===numberOfHeightLines)this.__context.moveTo((startPoint.x-(this.__lineWidth/2|0)|0)+(this.__lineWidth%2==0?0:.5),(0|startPoint.y)+(this.__lineWidth%2==0?0:.5)),this.__context.lineTo((startPoint.x+width+(this.__lineWidth/2|0)|0)+(this.__lineWidth%2==0?0:.5),(0|startPoint.y)+(this.__lineWidth%2==0?0:.5));else{let yDiff=height/(numberOfHeightLines-1);for(let i=0;i<numberOfHeightLines;i++)this.__context.moveTo((startPoint.x-(this.__lineWidth/2|0)|0)+(this.__lineWidth%2==0?0:.5),(startPoint.y-i*yDiff|0)+(this.__lineWidth%2==0?0:.5)),this.__context.lineTo((startPoint.x+width+(this.__lineWidth/2|0)|0)+(this.__lineWidth%2==0?0:.5),(startPoint.y-i*yDiff|0)+(this.__lineWidth%2==0?0:.5))}this.__context.stroke()}}}}TcHmiCharting.Grid=Grid}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class Subgrid extends TcHmiCharting.IGrid{constructor(canvas){super(canvas)}draw(startPoint,width,height,numberOfLinesBetweenMainGridWidth,widthBetweenMainGrid,numberOfLinesBetweenMainGridHeight,heightBetweenMainGrid,numberOfMainGridWidthLines,numberOfMainGridHeightLines,gridLineWidth,drawingBorder){if(null!==this.__context){if(null===this.__lineColor||null===this.__lineWidth)return;let xBegin=startPoint.x;startPoint.y;if(null!==this.__context&&(this.__context.strokeStyle=this.__lineColor,this.__context.lineWidth=this.__lineWidth,this.__lineStyle)){if(TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Solid?(this.__context.setLineDash([]),this.__context.lineCap="butt"):TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Dashed?(this.__context.lineCap="butt",1!==this.__lineWidth?this.__context.setLineDash([this.__lineWidth,this.__lineWidth]):this.__context.setLineDash([this.__lineWidth,2])):TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Dotted&&(this.__context.lineCap="round",this.__context.setLineDash([1,2*this.__lineWidth])),this.__context.beginPath(),this.__showVerticalLines&&numberOfLinesBetweenMainGridWidth){let xDiff=widthBetweenMainGrid/(numberOfLinesBetweenMainGridWidth+1),yStart=startPoint.y;TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Dotted&&(yStart-=this.__lineWidth/2);for(let j=0;j<numberOfMainGridWidthLines-1;j++){startPoint.x=startPoint.x+xDiff;for(let i=0;i<numberOfLinesBetweenMainGridWidth;i++)this.__context.moveTo((startPoint.x+i*xDiff|0)+(this.__lineWidth%2==0?0:.5),(yStart+(gridLineWidth/2|0)|0)-(this.__lineWidth%2==0?0:.5)),this.__context.lineTo((startPoint.x+i*xDiff|0)+(this.__lineWidth%2==0?0:.5),(yStart-height+(gridLineWidth/2|0)|0)-(this.__lineWidth%2==0?0:.5));startPoint.x=startPoint.x+(numberOfLinesBetweenMainGridWidth-1)*xDiff+xDiff}}if(this.__showHorizontalLines&&numberOfLinesBetweenMainGridHeight){let yDiff=heightBetweenMainGrid/(numberOfLinesBetweenMainGridHeight+1);TcHmiCharting.IGrid.LineStyle[this.__lineStyle]===TcHmiCharting.IGrid.LineStyle.Dotted&&(xBegin+=this.__lineWidth/2,width-=this.__lineWidth);for(let j=0;j<numberOfMainGridHeightLines-1;j++){startPoint.y=startPoint.y-yDiff;for(let i=0;i<numberOfLinesBetweenMainGridHeight;i++)this.__context.moveTo((xBegin-(gridLineWidth/2|0)|0)+(this.__lineWidth%2==0?0:.5),(startPoint.y-i*yDiff|0)+(this.__lineWidth%2==0?0:.5)),this.__context.lineTo((xBegin-(gridLineWidth/2|0)+width|0)+(this.__lineWidth%2==0?0:.5),(startPoint.y-i*yDiff|0)+(this.__lineWidth%2==0?0:.5));startPoint.y=startPoint.y-(numberOfLinesBetweenMainGridHeight-1)*yDiff-yDiff}}this.__context.stroke()}}}}TcHmiCharting.Subgrid=Subgrid}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";TcHmiCharting.IGraph=class{constructor(canvas){this.__context=null,this.__canvas=canvas,void 0!==this.__canvas&&(this.__context=this.__canvas.getContext("2d"))}}}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class LineGraph extends TcHmiCharting.IGraph{constructor(canvas){super(canvas),this.__lineWidth=null,this.__lineColor=null,this.__pointDot=!1,this.__pointDotRadius=null,this.__pointDotFillColor=null,this.__pointDotStrokeWidth=null,this.__pointDotStrokeColor=null,this.__points=[],this.__drawingBorder=0,this.__points=[]}draw(line,xAxis){if(this.__points.splice(0,this.__points.length),null!==line.yAxis){let yAxisLineWidth=line.yAxis.getAxisWidth();if(null===yAxisLineWidth)return;let offsetTop=line.yAxis.getDiffEndLabelAndLine()+yAxisLineWidth/2+5+this.__drawingBorder,offsetLeft=xAxis.getXAxisLeftWidth()||0,xStartValue=xAxis.getMainTickStartValue();if(xAxis.getAutoScaling()){let valueOverride=xAxis.getMainTickStartValueOverride();null!==valueOverride&&(xStartValue=valueOverride)}if(null===xStartValue)return;let yStartValue=line.yAxis.getMainTickStartValue();if(line.yAxis.getAutoScaling()){let valueOverride=line.yAxis.getMainTickStartValueOverride();null!==valueOverride&&(yStartValue=valueOverride)}if(null===yStartValue)return;let xAxisLabel=xAxis.getCalculatedNumbers(),yAxisLabel=line.yAxis.getCalculatedNumbers(),xAxisMainTickSteps=xAxis.getMainTickSteps();if(null===xAxisMainTickSteps)return;let yAxisMainTickSteps=line.yAxis.getMainTickSteps();if(null===yAxisMainTickSteps)return;let xAxisLegth=xAxis.getLineWidth(),xCalc=xAxisLegth/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]),yAxisLength=line.yAxis.getLineHeight(),yCalc=yAxisLength/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]),points=[];if(null!==this.__context&&void 0!==this.__canvas){if(this.__pointDot&&null!==this.__pointDotRadius&&null!==this.__pointDotStrokeWidth&&null!==this.__pointDotStrokeColor){if(this.__pointDotStrokeWidth>0){this.__context.beginPath(),this.__context.strokeStyle=this.__pointDotStrokeColor,this.__context.lineWidth=2*this.__pointDotRadius+this.__pointDotStrokeWidth,this.__context.lineCap="round";for(let i=0,ii=line.points.length-1;i<=ii;i++){let x=(line.points[i].x-xStartValue)*xCalc+offsetLeft,y=yAxisLength-(line.points[i].y-yStartValue)*yCalc+offsetTop,xMiddle=(0|x)+(this.__context.lineWidth%2==0?0:.5),yMiddle=(0|y)+(this.__context.lineWidth%2==0?0:.5);this.__context.moveTo(xMiddle,yMiddle),this.__context.lineTo(xMiddle,yMiddle),points.push({x:xMiddle,y:yMiddle})}this.__context.stroke()}if("None"!==this.__pointDotFillColor&&null!==this.__pointDotFillColor&&void 0!==this.__pointDotFillColor){this.__context.beginPath(),this.__context.strokeStyle=this.__pointDotFillColor,this.__context.lineWidth=2*this.__pointDotRadius,this.__context.lineCap="round";for(let i=0,ii=points.length-1;i<=ii;i++)this.__context.moveTo(points[i].x,points[i].y),this.__context.lineTo(points[i].x,points[i].y);this.__context.stroke()}}if(null!==this.__lineColor&&null!==this.__lineWidth){this.__context.beginPath(),this.__context.strokeStyle=this.__lineColor,this.__context.lineWidth=this.__lineWidth,this.__context.setLineDash([]);for(let i=0,ii=line.points.length-1;i<=ii;i++){let x,y;this.__pointDot?(x=points[i].x,y=points[i].y):(x=((line.points[i].x-xStartValue)*xCalc+offsetLeft|0)+(this.__lineWidth%2==0?0:.5),y=(yAxisLength-(line.points[i].y-yStartValue)*yCalc+offsetTop|0)+(this.__lineWidth%2==0?0:.5)),0===i?this.__context.moveTo(x,y):this.__context.lineTo(x,y)}this.__context.stroke()}this.__context.clearRect(0,0,this.__canvas.width,offsetTop),this.__context.clearRect(0,0,offsetLeft,this.__canvas.height),this.__context.clearRect(0,this.__canvas.height,this.__canvas.width,-(this.__canvas.height-yAxisLength-offsetTop)),this.__context.clearRect(this.__canvas.width,0,-(this.__canvas.width-offsetLeft-xAxisLegth),this.__canvas.height)}this.__points=points.splice(0),points.splice(0,points.length)}}getPoints(){return this.__points}removePoints(){this.__points.splice(0,this.__points.length)}setLineWidth(lineWidth){this.__lineWidth=null===lineWidth||lineWidth<=0?null:lineWidth}getLineWidth(){return this.__lineWidth}setLineColor(lineColor){this.__lineColor=lineColor}getLineColor(){return this.__lineColor}setPointDot(pointDot){this.__pointDot=pointDot}getPointDot(){return this.__pointDot}setPointDotRadius(pointDotRadius){this.__pointDotRadius=pointDotRadius}getPointDotRadius(){return this.__pointDotRadius}setPointDotFillColor(pointDotFillColor){this.__pointDotFillColor=pointDotFillColor}getPointDotFillColor(){return this.__pointDotFillColor}setPointDotStrokeWidth(pointDotStrokeWidth){this.__pointDotStrokeWidth=pointDotStrokeWidth}getPointDotStrokeWidth(){return this.__pointDotStrokeWidth}setPointDotStrokeColor(pointDotStrokeColor){this.__pointDotStrokeColor=pointDotStrokeColor}getPointDotStrokeColor(){return this.__pointDotStrokeColor}setCanvas(canvas){this.__canvas=canvas,this.__context=this.__canvas.getContext("2d")}getCanvas(){return this.__canvas}setDrawingBorder(drawingBorder){this.__drawingBorder=drawingBorder}}TcHmiCharting.LineGraph=LineGraph}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class LineAreaGraph extends TcHmiCharting.IGraph{constructor(canvas){super(canvas),this.__lineWidth=null,this.__lineColor=null,this.__pointDot=!1,this.__pointDotRadius=null,this.__pointDotFillColor=null,this.__pointDotStrokeWidth=null,this.__pointDotStrokeColor=null,this.__points=[],this.__areaPoints=[],this.__drawingBorder=0,this.__areas=[],this.__points=[]}draw(line,xAxis){if(this.__points.splice(0,this.__points.length),this.__areaPoints.splice(0,this.__areaPoints.length),null!==this.__context&&void 0!==this.__canvas&&line.yAxis){let areas=[];for(let i=0,ii=this.__areas.length;i<ii;i++){let __this=this,foundedArea=areas.filter(x=>x.getBackgroundColor()===__this.__areas[i].backgroundColor);if(0===foundedArea.length){areas.push(new TcHmiCharting.Area(this.__canvas));let newArea=areas[areas.length-1];newArea.setBackgroundColor(this.__areas[i].backgroundColor),newArea.setDrawLineWithOnePixel(this.__areas[i].drawLineWithOnePixel),newArea.addArea({beginX:this.__areas[i].beginX,endX:this.__areas[i].endX})}else foundedArea[0].addArea({beginX:this.__areas[i].beginX,endX:this.__areas[i].endX})}let allAreaPositionAndValues=[];for(let h=0,hh=areas.length;h<hh;h++)areas[h].setCanvas(this.__canvas),areas[h].setDrawingBorder(this.__drawingBorder),areas[h].draw(xAxis,line.yAxis),allAreaPositionAndValues=allAreaPositionAndValues.concat(areas[h].getAreasPositionAndValue()),areas[h].removeAllAreas();this.__areaPoints=allAreaPositionAndValues.splice(0),allAreaPositionAndValues.splice(0,allAreaPositionAndValues.length),areas.splice(0,areas.length),this.__context.globalAlpha=1;let yAxisLineWidth=line.yAxis.getAxisWidth();if(null===yAxisLineWidth)return;let offsetTop=line.yAxis.getDiffEndLabelAndLine()+yAxisLineWidth/2+5+this.__drawingBorder,offsetLeft=xAxis.getXAxisLeftWidth()||0,xStartValue=xAxis.getMainTickStartValue();if(xAxis.getAutoScaling()){let valueOverride=xAxis.getMainTickStartValueOverride();null!==valueOverride&&(xStartValue=valueOverride)}if(null===xStartValue)return;let yStartValue=line.yAxis.getMainTickStartValue();if(line.yAxis.getAutoScaling()){let valueOverride=line.yAxis.getMainTickStartValueOverride();null!==valueOverride&&(yStartValue=valueOverride)}if(null===yStartValue)return;let xAxisLabel=xAxis.getCalculatedNumbers(),yAxisLabel=line.yAxis.getCalculatedNumbers(),xAxisMainTickSteps=xAxis.getMainTickSteps();if(null===xAxisMainTickSteps)return;let yAxisMainTickSteps=line.yAxis.getMainTickSteps();if(null===yAxisMainTickSteps)return;let xAxisLegth=xAxis.getLineWidth(),xCalc=xAxisLegth/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]),yAxisLength=line.yAxis.getLineHeight(),yCalc=yAxisLength/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]),points=[];if(this.__pointDot&&null!==this.__pointDotRadius&&null!==this.__pointDotStrokeWidth&&null!==this.__pointDotStrokeColor){if(this.__pointDotStrokeWidth>0){this.__context.beginPath(),this.__context.strokeStyle=this.__pointDotStrokeColor,this.__context.lineWidth=2*this.__pointDotRadius+this.__pointDotStrokeWidth,this.__context.lineCap="round";for(let m=0,mm=line.points.length;m<mm;m++){let yValue=line.points[m].y;if(!line.points[m].isArea&&void 0!==yValue){let xMiddle=(line.points[m].x-xStartValue)*xCalc+offsetLeft,yMiddle=yAxisLength-(yValue-yStartValue)*yCalc+offsetTop;this.__context.moveTo(xMiddle,yMiddle),this.__context.lineTo(xMiddle,yMiddle),points.push({xPosition:xMiddle,yPosition:yMiddle,xValue:line.points[m].x,yValue:yValue})}}this.__context.stroke()}if("None"!==this.__pointDotFillColor&&null!==this.__pointDotFillColor&&void 0!==this.__pointDotFillColor){this.__context.beginPath(),this.__context.strokeStyle=this.__pointDotFillColor,this.__context.lineWidth=2*this.__pointDotRadius,this.__context.lineCap="round";for(let k=0,kk=points.length;k<kk;k++)this.__context.moveTo(points[k].xPosition,points[k].yPosition),this.__context.lineTo(points[k].xPosition,points[k].yPosition);this.__context.stroke()}}if(null!==this.__lineColor&&null!==this.__lineWidth){this.__context.beginPath(),this.__context.strokeStyle=this.__lineColor,this.__context.lineWidth=this.__lineWidth,this.__context.setLineDash([]);let bindPoints=!0,toFirstPoint=!1;for(let j=0,jj=line.points.length;j<jj;j++){let yValue=line.points[j].y;if(!line.points[j].isArea&&void 0!==yValue){let x=(line.points[j].x-xStartValue)*xCalc+offsetLeft,y=yAxisLength-(yValue-yStartValue)*yCalc+offsetTop;toFirstPoint&&bindPoints?this.__context.lineTo(x,y):(toFirstPoint=!0,this.__context.moveTo(x,y)),bindPoints=line.points[j].bindPoints}}this.__context.stroke()}this.__context.clearRect(0,0,this.__canvas.width,offsetTop),this.__context.clearRect(0,0,offsetLeft,this.__canvas.height),this.__context.clearRect(0,this.__canvas.height,this.__canvas.width,-(this.__canvas.height-yAxisLength-offsetTop)),this.__context.clearRect(this.__canvas.width,0,-(this.__canvas.width-offsetLeft-xAxisLegth),this.__canvas.height),this.__points=points.splice(0),points.splice(0,points.length)}}drawAreas(line,xAxis){if(this.__areaPoints.splice(0,this.__areaPoints.length),null!==this.__context&&void 0!==this.__canvas&&line.yAxis){let areas=[];for(let i=0,ii=this.__areas.length;i<ii;i++){let __this=this,foundedArea=areas.filter(x=>x.getBackgroundColor()===__this.__areas[i].backgroundColor);if(0===foundedArea.length){areas.push(new TcHmiCharting.Area(this.__canvas));let newArea=areas[areas.length-1];newArea.setBackgroundColor(this.__areas[i].backgroundColor),newArea.setDrawLineWithOnePixel(this.__areas[i].drawLineWithOnePixel),newArea.addArea({beginX:this.__areas[i].beginX,endX:this.__areas[i].endX})}else foundedArea[0].addArea({beginX:this.__areas[i].beginX,endX:this.__areas[i].endX})}let allAreaPositionAndValues=[];for(let h=0,hh=areas.length;h<hh;h++)areas[h].setCanvas(this.__canvas),areas[h].setDrawingBorder(this.__drawingBorder),areas[h].draw(xAxis,line.yAxis),allAreaPositionAndValues=allAreaPositionAndValues.concat(areas[h].getAreasPositionAndValue()),areas[h].removeAllAreas();this.__areaPoints=allAreaPositionAndValues.splice(0),allAreaPositionAndValues.splice(0,allAreaPositionAndValues.length),areas.splice(0,areas.length),this.__context.globalAlpha=1;let yAxisLineWidth=line.yAxis.getAxisWidth();if(null===yAxisLineWidth)return;let offsetTop=line.yAxis.getDiffEndLabelAndLine()+yAxisLineWidth/2+5+this.__drawingBorder,offsetLeft=xAxis.getXAxisLeftWidth()||0,xStartValue=xAxis.getMainTickStartValue();if(xAxis.getAutoScaling()){let valueOverride=xAxis.getMainTickStartValueOverride();null!==valueOverride&&(xStartValue=valueOverride)}if(null===xStartValue)return;let yStartValue=line.yAxis.getMainTickStartValue();if(line.yAxis.getAutoScaling()){let valueOverride=line.yAxis.getMainTickStartValueOverride();null!==valueOverride&&(yStartValue=valueOverride)}if(null===yStartValue)return;let xAxisLabel=xAxis.getCalculatedNumbers(),yAxisLabel=line.yAxis.getCalculatedNumbers(),xAxisMainTickSteps=xAxis.getMainTickSteps();if(null===xAxisMainTickSteps)return;let yAxisMainTickSteps=line.yAxis.getMainTickSteps();if(null===yAxisMainTickSteps)return;let xAxisLegth=xAxis.getLineWidth(),yAxisLength=(xAxisLabel[xAxisMainTickSteps-1],xAxisLabel[0],line.yAxis.getLineHeight());yAxisLabel[yAxisMainTickSteps-1],yAxisLabel[0];this.__context.clearRect(0,0,this.__canvas.width,offsetTop),this.__context.clearRect(0,0,offsetLeft,this.__canvas.height),this.__context.clearRect(0,this.__canvas.height,this.__canvas.width,-(this.__canvas.height-yAxisLength-offsetTop)),this.__context.clearRect(this.__canvas.width,0,-(this.__canvas.width-offsetLeft-xAxisLegth),this.__canvas.height)}}drawPoints(line,xAxis){if(this.__points.splice(0,this.__points.length),null!==this.__context&&void 0!==this.__canvas&&line.yAxis){this.__context.globalAlpha=1;let yAxisLineWidth=line.yAxis.getAxisWidth();if(null===yAxisLineWidth)return;let offsetTop=line.yAxis.getDiffEndLabelAndLine()+yAxisLineWidth/2+5+this.__drawingBorder,offsetLeft=xAxis.getXAxisLeftWidth()||0,xStartValue=xAxis.getMainTickStartValue();if(xAxis.getAutoScaling()){let valueOverride=xAxis.getMainTickStartValueOverride();null!==valueOverride&&(xStartValue=valueOverride)}if(null===xStartValue)return;let yStartValue=line.yAxis.getMainTickStartValue();if(line.yAxis.getAutoScaling()){let valueOverride=line.yAxis.getMainTickStartValueOverride();null!==valueOverride&&(yStartValue=valueOverride)}if(null===yStartValue)return;let xAxisLabel=xAxis.getCalculatedNumbers(),yAxisLabel=line.yAxis.getCalculatedNumbers(),xAxisMainTickSteps=xAxis.getMainTickSteps();if(null===xAxisMainTickSteps)return;let yAxisMainTickSteps=line.yAxis.getMainTickSteps();if(null===yAxisMainTickSteps)return;let xAxisLegth=xAxis.getLineWidth(),xCalc=xAxisLegth/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]),yAxisLength=line.yAxis.getLineHeight(),yCalc=yAxisLength/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]),points=[];if(this.__pointDot&&null!==this.__pointDotRadius&&null!==this.__pointDotStrokeWidth&&null!==this.__pointDotStrokeColor){if(this.__pointDotStrokeWidth>0){this.__context.beginPath(),this.__context.strokeStyle=this.__pointDotStrokeColor,this.__context.lineWidth=2*this.__pointDotRadius+this.__pointDotStrokeWidth,this.__context.lineCap="round";for(let m=0,mm=line.points.length;m<mm;m++){let yValue=line.points[m].y;if(!line.points[m].isArea&&void 0!==yValue){let xMiddle=(line.points[m].x-xStartValue)*xCalc+offsetLeft,yMiddle=yAxisLength-(yValue-yStartValue)*yCalc+offsetTop;this.__context.moveTo(xMiddle,yMiddle),this.__context.lineTo(xMiddle,yMiddle),points.push({xPosition:xMiddle,yPosition:yMiddle,xValue:line.points[m].x,yValue:yValue})}}this.__context.stroke()}if("None"!==this.__pointDotFillColor&&null!==this.__pointDotFillColor&&void 0!==this.__pointDotFillColor){this.__context.beginPath(),this.__context.strokeStyle=this.__pointDotFillColor,this.__context.lineWidth=2*this.__pointDotRadius,this.__context.lineCap="round";for(let k=0,kk=points.length;k<kk;k++)this.__context.moveTo(points[k].xPosition,points[k].yPosition),this.__context.lineTo(points[k].xPosition,points[k].yPosition);this.__context.stroke()}}if(null!==this.__lineColor&&null!==this.__lineWidth){this.__context.beginPath(),this.__context.strokeStyle=this.__lineColor,this.__context.lineWidth=this.__lineWidth,this.__context.setLineDash([]);let bindPoints=!0,toFirstPoint=!1;for(let j=0,jj=line.points.length;j<jj;j++){let yValue=line.points[j].y;if(!line.points[j].isArea&&void 0!==yValue){let x=(line.points[j].x-xStartValue)*xCalc+offsetLeft,y=yAxisLength-(yValue-yStartValue)*yCalc+offsetTop;toFirstPoint&&bindPoints?this.__context.lineTo(x,y):(toFirstPoint=!0,this.__context.moveTo(x,y)),bindPoints=line.points[j].bindPoints}}this.__context.stroke()}this.__context.clearRect(0,0,this.__canvas.width,offsetTop),this.__context.clearRect(0,0,offsetLeft,this.__canvas.height),this.__context.clearRect(0,this.__canvas.height,this.__canvas.width,-(this.__canvas.height-yAxisLength-offsetTop)),this.__context.clearRect(this.__canvas.width,0,-(this.__canvas.width-offsetLeft-xAxisLegth),this.__canvas.height),this.__points=points.splice(0),points.splice(0,points.length)}}getPoints(){return this.__points}removePoints(){this.__points.splice(0,this.__points.length)}getAreaPoints(){return this.__areaPoints}removeAreaPoints(){this.__areaPoints.splice(0,this.__areaPoints.length)}setLineWidth(lineWidth){this.__lineWidth=null===lineWidth||lineWidth<=0?null:lineWidth}getLineWidth(){return this.__lineWidth}setLineColor(lineColor){this.__lineColor=lineColor}getLineColor(){return this.__lineColor}setPointDot(pointDot){this.__pointDot=pointDot}getPointDot(){return this.__pointDot}setPointDotRadius(pointDotRadius){this.__pointDotRadius=pointDotRadius}getPointDotRadius(){return this.__pointDotRadius}setPointDotFillColor(pointDotFillColor){this.__pointDotFillColor=pointDotFillColor}getPointDotFillColor(){return this.__pointDotFillColor}setPointDotStrokeWidth(pointDotStrokeWidth){this.__pointDotStrokeWidth=pointDotStrokeWidth}getPointDotStrokeWidth(){return this.__pointDotStrokeWidth}setPointDotStrokeColor(pointDotStrokeColor){this.__pointDotStrokeColor=pointDotStrokeColor}getPointDotStrokeColor(){return this.__pointDotStrokeColor}setCanvas(canvas){this.__canvas=canvas,this.__context=this.__canvas.getContext("2d")}getCanvas(){return this.__canvas}setDrawingBorder(drawingBorder){this.__drawingBorder=drawingBorder}addArea(newArea){this.__areas.push(newArea)}deleteAllAreas(){this.__areas.splice(0,this.__areas.length)}deleteArea(index){this.__areas.splice(index,1)}getAllAreas(){return this.__areas}getAreaAtPosition(index){return this.__areas[index]}}TcHmiCharting.LineAreaGraph=LineAreaGraph}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class BarGraph extends TcHmiCharting.IGraph{constructor(canvas){super(canvas),this.__barWidth=null,this.__barColor=null,this.__drawingBorder={height:0,width:0}}draw(bar,xAxis){if(null!==bar.yAxis){let yAxisWidth=bar.yAxis.getAxisWidth();if(null===yAxisWidth)return;let offsetTop=bar.yAxis.getDiffEndLabelAndLine()+yAxisWidth/2+5+this.__drawingBorder.height,offsetLeft=xAxis.getXAxisLeftWidth()||0,xStartValue=xAxis.getMainTickStartValue();if(xAxis.getAutoScaling()){let valueOverride=xAxis.getMainTickStartValueOverride();null!==valueOverride&&(xStartValue=valueOverride)}if(null===xStartValue)return;let yStartValue=bar.yAxis.getMainTickStartValue();if(bar.yAxis.getAutoScaling()){let valueOverride=bar.yAxis.getMainTickStartValueOverride();null!==valueOverride&&(yStartValue=valueOverride)}if(null===yStartValue)return;let xAxisLabel=xAxis.getCalculatedNumbers(),yAxisLabel=bar.yAxis.getCalculatedNumbers(),xAxisMainTickSteps=xAxis.getMainTickSteps();if(null===xAxisMainTickSteps)return;let yAxisMainTickSteps=bar.yAxis.getMainTickSteps();if(null===yAxisMainTickSteps)return;let xAxisLegth=xAxis.getLineWidth(),xCalc=xAxisLegth/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]),yAxisLength=bar.yAxis.getLineHeight(),yCalc=yAxisLength/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]);if(null!==this.__context&&void 0!==this.__canvas){if(null!==this.__barWidth&&null!==this.__barColor){this.__context.beginPath();let yBegin=yAxisLength-(0-yStartValue)*yCalc+offsetTop;for(let i=0,ii=bar.values.length-1;i<=ii;i++){let x=(i-xStartValue)*xCalc+offsetLeft-this.__barWidth/2,y=yAxisLength-(bar.values[i]-yStartValue)*yCalc+offsetTop;this.__context.fillStyle=this.__barColor,this.__context.fillRect(x,yBegin,this.__barWidth,y-yBegin)}}this.__context.clearRect(0,0,this.__canvas.width,offsetTop-this.__drawingBorder.height),this.__context.clearRect(0,0,offsetLeft-this.__drawingBorder.width,this.__canvas.height),this.__context.clearRect(0,this.__canvas.height,this.__canvas.width,-(this.__canvas.height-yAxisLength-offsetTop-this.__drawingBorder.height)),this.__context.clearRect(this.__canvas.width,0,-(this.__canvas.width-offsetLeft-xAxisLegth-this.__drawingBorder.width),this.__canvas.height)}}}drawClustered(bar,xAxis,index){if(null!==bar.yAxis){let yAxisWidth=bar.yAxis.getAxisWidth();if(null===yAxisWidth)return;let offsetTop=bar.yAxis.getDiffEndLabelAndLine()+yAxisWidth/2+5+this.__drawingBorder.height,offsetLeft=xAxis.getXAxisLeftWidth()||0,xStartValue=xAxis.getMainTickStartValue();if(xAxis.getAutoScaling()){let valueOverride=xAxis.getMainTickStartValueOverride();null!==valueOverride&&(xStartValue=valueOverride)}if(null===xStartValue)return;let yStartValue=bar.yAxis.getMainTickStartValue();if(bar.yAxis.getAutoScaling()){let valueOverride=bar.yAxis.getMainTickStartValueOverride();null!==valueOverride&&(yStartValue=valueOverride)}if(null===yStartValue)return;let xAxisLabel=xAxis.getCalculatedNumbers(),yAxisLabel=bar.yAxis.getCalculatedNumbers(),xAxisMainTickSteps=xAxis.getMainTickSteps();if(null===xAxisMainTickSteps)return;let yAxisMainTickSteps=bar.yAxis.getMainTickSteps();if(null===yAxisMainTickSteps)return;let xAxisLegth=xAxis.getLineWidth(),xCalc=xAxisLegth/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]),yAxisLength=bar.yAxis.getLineHeight(),yCalc=yAxisLength/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]);if(null!==this.__context&&void 0!==this.__canvas){if(null!==this.__barWidth&&null!==this.__barColor){this.__context.beginPath();let yBegin=yAxisLength-(0-yStartValue)*yCalc+offsetTop;for(let i=0,ii=bar.values.length-1;i<=ii;i++){let x=(i-xStartValue)*xCalc+offsetLeft-this.__drawingBorder.width+2*index+index*this.__barWidth,y=yAxisLength-(bar.values[i]-yStartValue)*yCalc+offsetTop;this.__context.fillStyle=this.__barColor,this.__context.fillRect(x,yBegin,this.__barWidth,y-yBegin)}}this.__context.clearRect(0,0,this.__canvas.width,offsetTop-this.__drawingBorder.height),this.__context.clearRect(0,0,offsetLeft-this.__drawingBorder.width,this.__canvas.height),this.__context.clearRect(0,this.__canvas.height,this.__canvas.width,-(this.__canvas.height-yAxisLength-offsetTop-this.__drawingBorder.height)),this.__context.clearRect(this.__canvas.width,0,-(this.__canvas.width-offsetLeft-xAxisLegth-this.__drawingBorder.width),this.__canvas.height)}}}setBarWidth(barWidth){this.__barWidth=barWidth}getBarWidth(){return this.__barWidth}setDrawingBorder(drawingBorder){this.__drawingBorder=drawingBorder}setBarColor(barColor){this.__barColor=barColor}getBarColor(){return this.__barColor}setCanvas(canvas){this.__canvas=canvas,this.__context=this.__canvas.getContext("2d")}getCanvas(){return this.__canvas}}TcHmiCharting.BarGraph=BarGraph,function(BarGraph){let BarGraphArrangement;!function(BarGraphArrangement){BarGraphArrangement.Overlapped="Overlapped",BarGraphArrangement.Clustered="Clustered"}(BarGraphArrangement=BarGraph.BarGraphArrangement||(BarGraph.BarGraphArrangement={}))}(BarGraph=TcHmiCharting.BarGraph||(TcHmiCharting.BarGraph={}))}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class HorizontalBarChart extends TcHmiCharting.IChart{constructor(elementRoot,canvasWidth,canvasHeight){super(elementRoot,canvasWidth,canvasHeight),this.__widthLeft=0,this.__calcBarWidth=0,this.__barWidth=null,this.__barGraphArrangement=null,this.__drawingBorder={height:0,width:0},this.__barGraph=[],this.__barGraphs=[],this.__barChanged=!1}deleteYAxis(index){for(let i=0,ii=this.__barGraph.length;i<ii;i++){const tempBarGraph=this.__barGraph[i];null!==tempBarGraph.yAxis&&tempBarGraph.yAxis.getId()===this.__yAxis[index].getId()&&(tempBarGraph.yAxis=null)}this.__yAxis.splice(index,1),this.setHasChanged(!0)}deleteAllYAxis(){this.__yAxis.splice(0,this.__yAxis.length);for(let i=0,ii=this.__barGraph.length;i<ii;i++)this.__barGraph[i].yAxis=null;this.setHasChanged(!0)}addGraph(newGraph){this.__canvasFrame&&(this.__barGraph.push(newGraph),this.__barGraphs.push(new TcHmiCharting.HorizontalBarGraph(this.__canvasFrame)),this.__barChanged=!0)}deleteGraph(index){this.__barGraph.splice(index,1),this.__barGraphs.splice(index,1),this.__barChanged=!0}deleteAllGraphs(){this.__barGraph.splice(0,this.__barGraph.length),this.__barGraphs.splice(0,this.__barGraphs.length),this.__barChanged=!0}remove(){super.remove(),this.deleteGrid(),this.deleteSubgrid(),this.deleteAllYAxis(),this.deleteAllGraphs(),this.__xAxis=null,this.__barWidth=null}clear(width,height){super.clear(width,height),this.deleteGrid(),this.deleteSubgrid(),this.deleteAllYAxis(),this.deleteAllGraphs(),this.__xAxis=null,this.__barWidth=null}getBars(){return this.__barGraph}getBarsAtPosition(index){return this.__barGraph[index]}getBarGraphs(){return this.__barGraphs}getBarGraphsAtPosition(index){return this.__barGraphs[index]}setBarWidth(barWidth){this.__barWidth=barWidth}setBarGraphArrangement(barGraphArrangement){this.__barGraphArrangement=barGraphArrangement}setBarChanged(barChanged){this.__barChanged=barChanged}draw(){if(null!==this.__canvasFrame&&void 0!==this.__canvasFrame)if(null!==this.__xAxis&&void 0!==this.__xAxis){if(this.getHasChanged()){null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height);let xAxisHeight=0,startValueX=null,endValueX=null;if(this.__xAxis.setMainTickStartValueOverride(null),this.__xAxis.setMainTickEndValueOverride(null),this.__xAxis.getAutoScaling())for(let j=0,jj=this.__barGraph.length;j<jj;j++){for(let k=0,kk=this.__barGraph[j].values.length;k<kk;k++)(null===startValueX||startValueX>this.__barGraph[j].values[k])&&(startValueX=this.__barGraph[j].values[k]),(null===endValueX||endValueX<this.__barGraph[j].values[k])&&(endValueX=this.__barGraph[j].values[k]);null!==startValueX&&null!==endValueX&&(startValueX===endValueX&&(startValueX-=.5,endValueX+=.5),this.__xAxis.setMainTickStartValueOverride(startValueX),this.__xAxis.setMainTickEndValueOverride(endValueX))}if(this.__xAxis.drawAxis({x:0,y:this.__canvasFrame.height},{x:this.__canvasFrame.width,y:this.__canvasFrame.height}),xAxisHeight=this.__xAxis.getHeight(),xAxisHeight>0?xAxisHeight+=10:xAxisHeight=5,null!==this.__yAxis&&void 0!==this.__yAxis&&this.__yAxis.length>0){null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height);let widthLeft=5,widthRight=5,showOnlyYAxis=!1,biggestFirst=0,biggestLatest=0;for(let h=0,hh=this.__yAxis.length;h<hh;h++){this.__yAxis[h].setMainTickStartValueOverride(null),this.__yAxis[h].setMainTickEndValueOverride(null);let startValue=0,endValue=null;if(this.__yAxis[h].getAutoScaling()){for(let j=0,jj=this.__barGraph.length;j<jj;j++)(null===endValue||endValue<this.__barGraph[j].values.length-1)&&(endValue=this.__barGraph[j].values.length-1);startValue=0,null!==startValue&&null!==endValue&&(startValue===endValue&&(startValue-=.5,endValue+=.5),this.__yAxis[h].setMainTickStartValueOverride(startValue),this.__yAxis[h].setMainTickEndValueOverride(endValue))}let yAxis=this.__yAxis[h],labelArray=yAxis.getCalculatedLabels();if(yAxis.getShowAxis()&&yAxis.getShowLabels()){let callback=yAxis.getYAxisCallback(),mainTickSteps=yAxis.getMainTickSteps();if(null!==callback){if(void 0!==labelArray[0]&&null!==labelArray[0]){let first=yAxis.calculateLabelHeight(callback.apply(this,[parseFloat(labelArray[0])]));first>biggestFirst&&(biggestFirst=first)}if(null!==mainTickSteps&&void 0!==labelArray[mainTickSteps-1]&&null!==labelArray[mainTickSteps-1]){let latest=yAxis.calculateLabelHeight(callback.apply(this,[parseFloat(labelArray[mainTickSteps-1])]));latest>biggestLatest&&(biggestLatest=latest)}}else{if(void 0!==labelArray[0]&&null!==labelArray[0]){let first=yAxis.calculateLabelHeight(labelArray[0]);first>biggestFirst&&(biggestFirst=first)}if(null!==mainTickSteps&&void 0!==labelArray[mainTickSteps-1]&&null!==labelArray[mainTickSteps-1]){let latest=yAxis.calculateLabelHeight(labelArray[mainTickSteps-1]);latest>biggestLatest&&(biggestLatest=latest)}}}}for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__xAxis.getShowAxis()||(showOnlyYAxis=!0),this.__yAxis[i].getPosition()===TcHmiCharting.IAxis.Position.Left?(this.__yAxis[i].drawAxis({x:widthLeft,y:this.__canvasFrame.height-xAxisHeight},{x:widthLeft,y:5},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),this.__yAxis[i].getShowAxis()&&(widthLeft=widthLeft+10+this.__yAxis[i].getWidth())):(this.__yAxis[i].drawAxis({x:this.__canvasFrame.width-widthRight,y:this.__canvasFrame.height-xAxisHeight},{x:this.__canvasFrame.width-widthRight,y:5},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),this.__yAxis[i].getShowAxis()&&(widthRight=widthRight+10+this.__yAxis[i].getWidth()));this.__canvasFrame.width-widthRight-widthLeft>0?this.__xAxis.drawAxis({x:widthLeft+this.__drawingBorder.width,y:this.__canvasFrame.height},{x:this.__canvasFrame.width-widthRight-this.__drawingBorder.width,y:this.__canvasFrame.height}):this.__xAxis.drawAxis({x:0,y:0},{x:0,y:0});let barWidth,yAxisLabel=this.__yAxis[0].getCalculatedNumbers(),yAxisMainTickSteps=this.__yMainTickSteps,barWdithDrawingBorder=0;if(null===this.__barWidth)if(this.__barGraphArrangement===TcHmiCharting.HorizontalBarGraph.BarGraphArrangement.Overlapped){if(this.__barGraph.length>0)if(null!==yAxisMainTickSteps&&yAxisMainTickSteps>1&&0!==yAxisLabel.length){let yCalc=this.__yAxis[0].getLineHeight()/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]);this.__calcBarWidth=Math.floor(Math.floor(yCalc)*(2/3)),this.__calcBarWidth<1&&(this.__calcBarWidth=1),barWdithDrawingBorder=this.__calcBarWidth}else this.__calcBarWidth=1,barWdithDrawingBorder=this.__calcBarWidth;else this.__calcBarWidth=0,barWdithDrawingBorder=this.__calcBarWidth;barWidth=this.__calcBarWidth}else{if(this.__barGraph.length>0)if(null!==yAxisMainTickSteps&&yAxisMainTickSteps>1&&0!==yAxisLabel.length){let yCalc=this.__yAxis[0].getLineHeight()/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]);if(this.__barGraph.length>0){let placeForAllBars=Math.floor(Math.floor(yCalc)*(2/3));barWdithDrawingBorder=placeForAllBars,this.__calcBarWidth=(placeForAllBars-2*(this.__barGraph.length-1))/this.__barGraph.length}else this.__calcBarWidth=Math.floor(Math.floor(yCalc)*(2/3)),barWdithDrawingBorder=this.__calcBarWidth;this.__calcBarWidth<1&&(this.__calcBarWidth=1,barWdithDrawingBorder=this.__calcBarWidth)}else this.__calcBarWidth=1,barWdithDrawingBorder=this.__calcBarWidth;else this.__calcBarWidth=0,barWdithDrawingBorder=this.__calcBarWidth;barWidth=this.__calcBarWidth}else barWidth=this.__barWidth,this.__barGraphArrangement===TcHmiCharting.HorizontalBarGraph.BarGraphArrangement.Overlapped?barWdithDrawingBorder=this.__barWidth:(barWdithDrawingBorder=this.__barWidth,this.__barGraph.length>1&&(barWdithDrawingBorder=2*((this.__barGraph.length-1)/2*2+this.__barGraph.length/2*this.__barWidth)));let gridLineWidth=0;null!==this.__grid&&(gridLineWidth=this.__grid.getLineWidth()||0,gridLineWidth/=2),this.__drawingBorder.height=gridLineWidth>barWdithDrawingBorder/2?gridLineWidth:barWdithDrawingBorder/2,this.__drawingBorder.width=gridLineWidth>5?gridLineWidth:5,this.__drawingBorder.width<5&&(this.__drawingBorder.width=5),null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height),widthLeft=5,widthRight=5;for(let i=0,ii=this.__yAxis.length;i<ii;i++)this.__yAxis[i].getPosition()===TcHmiCharting.IAxis.Position.Left?(this.__yAxis[i].drawAxis({x:widthLeft,y:this.__canvasFrame.height-xAxisHeight-this.__drawingBorder.height},{x:widthLeft,y:5+this.__drawingBorder.height},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),widthLeft=widthLeft+10+this.__yAxis[i].getWidth()):(this.__yAxis[i].drawAxis({x:this.__canvasFrame.width-widthRight,y:this.__canvasFrame.height-xAxisHeight-this.__drawingBorder.height},{x:this.__canvasFrame.width-widthRight,y:5+this.__drawingBorder.height},showOnlyYAxis,{first:biggestFirst,latest:biggestLatest}),widthRight=widthRight+10+this.__yAxis[i].getWidth());if(this.__canvasFrame.width-widthRight-widthLeft>0?this.__xAxis.drawAxis({x:widthLeft+this.__drawingBorder.width,y:this.__canvasFrame.height},{x:this.__canvasFrame.width-widthRight-this.__drawingBorder.width,y:this.__canvasFrame.height}):this.__xAxis.drawAxis({x:0,y:0},{x:0,y:0}),null===this.__barWidth)if(this.__barGraphArrangement===TcHmiCharting.HorizontalBarGraph.BarGraphArrangement.Overlapped){if(this.__barGraph.length>0)if(null!==yAxisMainTickSteps&&yAxisMainTickSteps>1&&0!==yAxisLabel.length){let yCalc=this.__yAxis[0].getLineHeight()/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]);this.__calcBarWidth=Math.floor(Math.floor(yCalc)*(2/3)),this.__calcBarWidth<1&&(this.__calcBarWidth=1)}else this.__calcBarWidth=1;else this.__calcBarWidth=0;barWidth=this.__calcBarWidth}else if(this.__barGraph.length>0)if(null!==yAxisMainTickSteps&&yAxisMainTickSteps>1&&0!==yAxisLabel.length){let yCalc=this.__yAxis[0].getLineHeight()/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]);if(this.__barGraph.length>0){let placeForAllBars=Math.floor(Math.floor(yCalc)*(2/3));this.__calcBarWidth=(placeForAllBars-2*(this.__barGraph.length-1))/this.__barGraph.length}else this.__calcBarWidth=Math.floor(Math.floor(yCalc)*(2/3));this.__calcBarWidth<1&&(this.__calcBarWidth=1)}else this.__calcBarWidth=1;else this.__calcBarWidth=0;let xAxisMainTickSteps=this.__xAxis.getMainTickSteps(),xAxisWidth=this.__xAxis.getAxisWidth(),yAxisWidth=this.getYAxisWidth();if(null!==xAxisMainTickSteps&&null!==yAxisMainTickSteps&&null!==xAxisWidth&&null!==yAxisWidth){let xAxisSubTickSteps=this.__xAxis.getSubTickSteps(),yAxisSubTickSteps=this.__ySubTickSteps,showGridHorizontal=!!this.__grid&&this.__grid.getShowHorizontalLines(),showGridVertical=!!this.__grid&&this.__grid.getShowVerticalLines(),showSubgridHorizontal=!!this.__subgrid&&this.__subgrid.getShowHorizontalLines(),showSubgridVertical=!!this.__subgrid&&this.__subgrid.getShowVerticalLines(),gridBackgroundColor=this.__grid?this.__grid.getBackgroundColor():null;((showGridHorizontal||showGridVertical)&&this.__grid&&null!==this.__grid.getLineColor()&&null!==this.__grid.getLineWidth()&&null!==this.__grid.getLineStyle()||(showSubgridHorizontal&&null!==yAxisSubTickSteps||showSubgridVertical&&null!==xAxisSubTickSteps)&&this.__subgrid&&null!==this.__subgrid.getLineColor()&&null!==this.__subgrid.getLineWidth()&&null!==this.__subgrid.getLineStyle())&&this.__contextFrame&&gridBackgroundColor&&(this.__contextFrame.fillStyle=gridBackgroundColor,showOnlyYAxis?this.__contextFrame.fillRect(this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder.width,this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2,this.__xAxis.getLineWidth()+2*this.__drawingBorder.width,-this.__yAxis[0].getLineHeight()-2*this.__drawingBorder.height):this.__contextFrame.fillRect(this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder.width,this.__canvasFrame.height-xAxisHeight-yAxisWidth/2,this.__xAxis.getLineWidth()+2*this.__drawingBorder.width,-this.__yAxis[0].getLineHeight()-2*this.__drawingBorder.height)),this.__subgrid&&this.__grid&&(showOnlyYAxis?this.__subgrid.draw({x:this.__xAxis.getXAxisLeftWidth(),y:this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2-this.__drawingBorder.height},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisSubTickSteps,this.__xAxis.getLineWidth()/(xAxisMainTickSteps-1),yAxisSubTickSteps,this.__yAxis[0].getLineHeight()/(yAxisMainTickSteps-1),xAxisMainTickSteps,yAxisMainTickSteps,this.__grid.getLineWidth()||0,this.__drawingBorder):this.__subgrid.draw({x:this.__xAxis.getXAxisLeftWidth(),y:this.__canvasFrame.height-xAxisHeight-yAxisWidth/2-this.__drawingBorder.height},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisSubTickSteps,this.__xAxis.getLineWidth()/(xAxisMainTickSteps-1),yAxisSubTickSteps,this.__yAxis[0].getLineHeight()/(yAxisMainTickSteps-1),xAxisMainTickSteps,yAxisMainTickSteps,this.__grid.getLineWidth()||0,this.__drawingBorder)),this.__grid&&(showOnlyYAxis?this.__grid.draw({x:this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder.width,y:this.__canvasFrame.height-xAxisHeight-this.__yAxis[0].getDiffStartLabelAndLine()-yAxisWidth/2},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisMainTickSteps,yAxisMainTickSteps,this.__drawingBorder):this.__grid.draw({x:this.__xAxis.getXAxisLeftWidth()-this.__drawingBorder.width,y:this.__canvasFrame.height-xAxisHeight-yAxisWidth/2},this.__xAxis.getLineWidth(),this.__yAxis[0].getLineHeight(),xAxisMainTickSteps,yAxisMainTickSteps,this.__drawingBorder))}this.__barChanged=!0,this.__widthLeft=this.__xAxis.getXAxisLeftWidth()}}if(this.__barChanged)if(null!==this.__yAxis&&void 0!==this.__yAxis)if(this.__yAxis.length>0){null!==this.__contextDrawing&&null!==this.__canvasDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);let canvasElem=this.__elementRoot.find(".TcHmi_Controls_Beckhoff_Controls-chart-canvas-drawing")[0];for(let i=0,ii=this.__barGraph.length;i<ii;i++)if(null!==this.__barGraph[i].yAxis&&void 0!==this.__barGraph[i].yAxis){let barGraph=this.__barGraphs[i];barGraph.setCanvas(canvasElem),null===this.__barWidth?barGraph.setBarWidth(this.__calcBarWidth):barGraph.setBarWidth(this.__barWidth),barGraph.setDrawingBorder(this.__drawingBorder),this.__barGraphArrangement===TcHmiCharting.HorizontalBarGraph.BarGraphArrangement.Overlapped?barGraph.draw(this.__barGraph[i],this.__xAxis):barGraph.drawClustered(this.__barGraph[i],this.__xAxis,i)}this.__barChanged=!1}else null!==this.__contextDrawing&&null!==this.__canvasDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);else null!==this.__contextDrawing&&null!==this.__canvasDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height);this.setHasChanged(!1)}else null!==this.__contextFrame&&this.__contextFrame.clearRect(0,0,this.__canvasFrame.width,this.__canvasFrame.height),null!==this.__contextDrawing&&null!==this.__canvasDrawing&&this.__contextDrawing.clearRect(0,0,this.__canvasDrawing.width,this.__canvasDrawing.height)}}TcHmiCharting.HorizontalBarChart=HorizontalBarChart}(TcHmiCharting||(TcHmiCharting={})),function(TcHmiCharting){"use strict";class HorizontalBarGraph extends TcHmiCharting.IGraph{constructor(canvas){super(canvas),this.__barWidth=null,this.__barColor=null,this.__drawingBorder={height:0,width:0}}draw(bar,xAxis){if(null!==bar.yAxis){let yAxisWidth=bar.yAxis.getAxisWidth();if(null===yAxisWidth)return;let offsetTop=bar.yAxis.getDiffEndLabelAndLine()+yAxisWidth/2+5+this.__drawingBorder.height,offsetLeft=xAxis.getXAxisLeftWidth()||0,xStartValue=xAxis.getMainTickStartValue();if(xAxis.getAutoScaling()){let valueOverride=xAxis.getMainTickStartValueOverride();null!==valueOverride&&(xStartValue=valueOverride)}if(null===xStartValue)return;let yStartValue=bar.yAxis.getMainTickStartValue();if(bar.yAxis.getAutoScaling()){let valueOverride=bar.yAxis.getMainTickStartValueOverride();null!==valueOverride&&(yStartValue=valueOverride)}if(null===yStartValue)return;let xAxisLabel=xAxis.getCalculatedNumbers(),yAxisLabel=bar.yAxis.getCalculatedNumbers(),xAxisMainTickSteps=xAxis.getMainTickSteps();if(null===xAxisMainTickSteps)return;let yAxisMainTickSteps=bar.yAxis.getMainTickSteps();if(null===yAxisMainTickSteps)return;let xAxisLength=xAxis.getLineWidth(),xCalc=xAxisLength/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]),yAxisLength=bar.yAxis.getLineHeight(),yCalc=yAxisLength/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]);if(null!==this.__context&&void 0!==this.__canvas){if(null!==this.__barWidth&&null!==this.__barColor){this.__context.beginPath();let xBegin=(0-xStartValue)*xCalc+offsetLeft;for(let i=0,ii=bar.values.length-1;i<=ii;i++){let y=yAxisLength-(i-yStartValue)*yCalc+offsetTop-this.__barWidth/2,x=(bar.values[i]-xStartValue)*xCalc+offsetLeft;this.__context.fillStyle=this.__barColor,this.__context.fillRect(xBegin,y,x-xBegin,this.__barWidth)}}this.__context.clearRect(0,0,this.__canvas.width,offsetTop-this.__drawingBorder.height),this.__context.clearRect(0,0,offsetLeft-this.__drawingBorder.width,this.__canvas.height),this.__context.clearRect(0,this.__canvas.height,this.__canvas.width,-(this.__canvas.height-yAxisLength-offsetTop-this.__drawingBorder.height)),this.__context.clearRect(this.__canvas.width,0,-(this.__canvas.width-offsetLeft-xAxisLength-this.__drawingBorder.width),this.__canvas.height)}}}drawClustered(bar,xAxis,index){if(null!==bar.yAxis){let yAxisWidth=bar.yAxis.getAxisWidth();if(null===yAxisWidth)return;let offsetTop=bar.yAxis.getDiffEndLabelAndLine()+yAxisWidth/2+5+this.__drawingBorder.height,offsetLeft=xAxis.getXAxisLeftWidth()||0,xStartValue=xAxis.getMainTickStartValue();if(xAxis.getAutoScaling()){let valueOverride=xAxis.getMainTickStartValueOverride();null!==valueOverride&&(xStartValue=valueOverride)}if(null===xStartValue)return;let yStartValue=bar.yAxis.getMainTickStartValue();if(bar.yAxis.getAutoScaling()){let valueOverride=bar.yAxis.getMainTickStartValueOverride();null!==valueOverride&&(yStartValue=valueOverride)}if(null===yStartValue)return;let xAxisLabel=xAxis.getCalculatedNumbers(),yAxisLabel=bar.yAxis.getCalculatedNumbers(),xAxisMainTickSteps=xAxis.getMainTickSteps();if(null===xAxisMainTickSteps)return;let yAxisMainTickSteps=bar.yAxis.getMainTickSteps();if(null===yAxisMainTickSteps)return;let xAxisLength=xAxis.getLineWidth(),xCalc=xAxisLength/(xAxisLabel[xAxisMainTickSteps-1]-xAxisLabel[0]),yAxisLength=bar.yAxis.getLineHeight(),yCalc=yAxisLength/(yAxisLabel[yAxisMainTickSteps-1]-yAxisLabel[0]);if(null!==this.__context&&void 0!==this.__canvas){if(null!==this.__barWidth&&null!==this.__barColor){this.__context.beginPath();let xBegin=(0-xStartValue)*xCalc+offsetLeft;for(let i=0,ii=bar.values.length-1;i<=ii;i++){let startingY=yAxisLength-(i-yStartValue)*yCalc+offsetTop-this.__drawingBorder.height,x=(bar.values[i]-xStartValue)*xCalc+offsetLeft,y=startingY+2*index+index*this.__barWidth;this.__context.fillStyle=this.__barColor,this.__context.fillRect(xBegin,y,x-xBegin,this.__barWidth)}}this.__context.clearRect(0,0,this.__canvas.width,offsetTop-this.__drawingBorder.height),this.__context.clearRect(0,0,offsetLeft-this.__drawingBorder.width,this.__canvas.height),this.__context.clearRect(0,this.__canvas.height,this.__canvas.width,-(this.__canvas.height-yAxisLength-offsetTop-this.__drawingBorder.height)),this.__context.clearRect(this.__canvas.width,0,-(this.__canvas.width-offsetLeft-xAxisLength-this.__drawingBorder.width),this.__canvas.height)}}}setBarWidth(barWidth){this.__barWidth=barWidth}getBarWidth(){return this.__barWidth}setDrawingBorder(drawingBorder){this.__drawingBorder=drawingBorder}setBarColor(barColor){this.__barColor=barColor}getBarColor(){return this.__barColor}setCanvas(canvas){this.__canvas=canvas,this.__context=this.__canvas.getContext("2d")}getCanvas(){return this.__canvas}}TcHmiCharting.HorizontalBarGraph=HorizontalBarGraph,function(HorizontalBarGraph){let BarGraphArrangement;!function(BarGraphArrangement){BarGraphArrangement.Overlapped="Overlapped",BarGraphArrangement.Clustered="Clustered"}(BarGraphArrangement=HorizontalBarGraph.BarGraphArrangement||(HorizontalBarGraph.BarGraphArrangement={}))}(HorizontalBarGraph=TcHmiCharting.HorizontalBarGraph||(TcHmiCharting.HorizontalBarGraph={}))}(TcHmiCharting||(TcHmiCharting={}));