﻿// Keep these lines for a best effort IntelliSense of Visual Studio 2017.
/// <reference path="./../../Packages/Beckhoff.TwinCAT.HMI.Framework.12.752.0/runtimes/native1.12-tchmi/TcHmi.d.ts" />



let singleOutputTag =
{
    "output": "",
    "matchingstate": true,
    "currentvalue": true,
    "notified": false,
    "comment": ""
}

let errorInput = {
    "state": false,
    "alwaysactive": true,
    "alwaysinactive": true
}

let singleInput =
{
    "input": "",
    "currentoutput": true,
    "dataprocessed": false,
    "value": true,
    "delay": 2,
    "ignore": false,
    "errorinput": errorInput
}

let analogMaxMin = {
    "max": 500,
    "min": 0
}

let analogError = {
    "state": false,
    "nodata": true,
    "randomdata": true
}

let singleAnalogData =
{
    "address": "",
    "dataprocessed": true,
    "values": analogMaxMin,
    "delay": 2,
    "ignore": false,
    "erroranalog": analogError,
    "duration": 0,
    "keepmiddle": false,
    "comment": ""
}

var aGlobalRootObject =
{
    "singleoutputs": [],
    "ignore": false,
    "comment": "",
    "singleinputs": [],
    "singleanalogdatas": []
};




function ReadFromServer(symbolString) {
    return new Promise((resolve, reject) => {
        var symbol = new TcHmi.Symbol(symbolString);
        symbol.readEx(function (data) {
            if (data.error === TcHmi.Errors.NONE) {
                resolve(data.value);
            } else {
                var errorString = `Error in ReadFromServer symbolString = ${symbolString}`;
                reject(errorString);
            }
        });
    });
}
function WriteToServer(symbolParameter, dataParameter) {
    return new Promise((resolve, reject) => {
        TcHmi.Symbol.writeEx(symbolParameter, dataParameter, function (data) {
            if (data.error === TcHmi.Errors.NONE) {
                resolve(data.value);
            } else {
                var errorString = `Error in WriteToServer symbolParameter = ${symbolParameter}, dataParameter = ${dataParameter}`;
                reject(errorString);
            }
        });
    });
}


function SaveDataToHardDrive( JsonData) {

 
        try {

            // Requiring fs module in which
            // writeFile function is defined.
            const fs = require('fs')


            // Write data in 'Output.txt' .
            fs.writeFile('Output.txt', JsonData, (err) => {

                // In case of a error throw err.
                if (err) throw err;
            })



        } catch (err) {
            console.error(err.name, err.message);
        }    
}






(function (/** @type {globalThis.TcHmi} */ TcHmi) {
    // If you want to unregister an event outside the event code you need to use the return value of the method register()
    var destroyOnInitialized = TcHmi.EventProvider.register('onInitialized', function (e, data) {
        // This event will be raised only once, so we can free resources. 
        // It's best practice to use destroy function of the event object within the callback function to avoid conflicts.
        e.destroy();
        // ----------------------
        // Place your code here!
        // ----------------------
    });
})(TcHmi);
