﻿// Keep these lines for a best effort IntelliSense of Visual Studio 2017 and higher.
/// <reference path="./../../Packages/Beckhoff.TwinCAT.HMI.Framework.12.752.0/runtimes/native1.12-tchmi/TcHmi.d.ts" />
(function (/** @type {globalThis.TcHmi} */ TcHmi) {
    var Functions;
    (function (/** @type {globalThis.TcHmi.Functions} */ Functions) {
        var HMIConfiguration;
        (function (HMIConfiguration) {
            function MonitorVariable() {


                var textStatusControl = TcHmi.Controls.get('TcHmiTextblock_TerminalState');
                var textPressureControl = TcHmi.Controls.get('TcHmiTextblock_PressureValue');
                var textTemperatureControl = TcHmi.Controls.get('TcHmiTextblock_Temperature');


                if (TcHmi.Server.isWebsocketReady()) {
                    var commands = [
                        { 'symbol': 'PLC1.MAIN.fnValve.terminalState' },
                        { 'symbol': 'PLC1.MAIN.fnValve.pressureRealValue' },
                        { 'symbol': 'PLC1.MAIN.fnValve.temperatureRealValue' }
                    ];
                    TcHmi.Server.subscribe(commands, 1000, function (data) {
                        if (data.error !== TcHmi.Errors.NONE) {
                            console.log(`MonitorVariable failed to subscribe data.details.code = ${data.details.code}`);
                            return;
                        }
                        var response = data.response;
                        if (!response || response.error !== undefined) {
                            console.log('MonitorVariable wrong response in MonitorVariable notification');
                            console.log(`MonitorVariable data.details.code = ${data.details.code}`);
                            return;
                        }
                        var commands = response.commands;
                        if (commands === undefined) {
                            console.log('MonitorVariable  initialization commands undefined');
                            console.log(`MonitorVariable data.details.code = ${data.details.code}`);
                            return;
                        }
                        for (var i = 0; i < commands.length; i++) {
                            var command = commands[i];
                            if (command === undefined) {
                                console.log('MonitorVariable  initialization commands undefined');
                                console.log(`MonitorVariable data.details.code = ${data.details.code}, symbol = ${command.symbol}`);
                                return;
                            }
                            if (command.error !== undefined) {
                                console.log(commands[i].symbol);
                                console.log('MonitorVariable initialization commands  for field devices, error has value, why?');
                                console.log(`MonitorVariable data.details.code = ${data.details.code}, symbol = ${command.symbol}`);
                                return;
                            }

                            if (commands[i].symbol.indexOf(".terminalState") > 0) {
                                textStatusControl.setText(command.readValue);                                
                            }

                            if (commands[i].symbol.indexOf(".pressureRealValue") > 0) {
                                textPressureControl.setText(command.readValue.toFixed(3));
                            }
                            if (commands[i].symbol.indexOf(".temperatureRealValue") > 0) {
                                textTemperatureControl.setText(command.readValue.toFixed(3));
                            }


                        } //for
                    });
                }//isWebsocketReady





            }
            HMIConfiguration.MonitorVariable = MonitorVariable;
        })(HMIConfiguration = Functions.HMIConfiguration || (Functions.HMIConfiguration = {}));
        Functions.registerFunctionEx('MonitorVariable', 'TcHmi.Functions.HMIConfiguration', HMIConfiguration.MonitorVariable);
    })(Functions = TcHmi.Functions || (TcHmi.Functions = {}));
})(TcHmi);