﻿// Keep these lines for a best effort IntelliSense of Visual Studio 2017 and higher.
/// <reference path="./../../Packages/Beckhoff.TwinCAT.HMI.Framework.12.752.0/runtimes/native1.12-tchmi/TcHmi.d.ts" />
(function (/** @type {globalThis.TcHmi} */ TcHmi) {
    var Functions;
    (function (/** @type {globalThis.TcHmi.Functions} */ Functions) {
        var TcHmiDisplayName;
        (function (TcHmiDisplayName) {
            function DisplayDeviceName(DeviceID) {
                // DeviceID is control id 
                var targetControlCircleAlarm = TcHmi.Controls.get(DeviceID);
                var width = targetControlCircleAlarm.getWidth();
                var height = targetControlCircleAlarm.getHeight();
                var left = targetControlCircleAlarm.getLeft();
                var top = targetControlCircleAlarm.getTop();
                var Content = 'UserControl/DeviceName.usercontrol';
                var deviceType = DeviceID.split("_");
                DeviceID = deviceType[0];
                var popupParametersPopupControl = [];
                popupParametersPopupControl['data-tchmi-height'] = 19;
                popupParametersPopupControl['data-tchmi-width'] = 181;
                popupParametersPopupControl['data-tchmi-zindex'] = "1000";
                popupParametersPopupControl['data-tchmi-name'] = DeviceID;
                popupParametersPopupControl['data-tchmi-left'] =  left + width / 2;
                popupParametersPopupControl['data-tchmi-top'] = top + height / 2;
                var PopupUuid = String("Popup_" + generateUuidv4());
                var popup;
                popupParametersPopupControl['data-tchmi-target-user-control'] = Content;
                popup = TcHmi.ControlFactory.createEx(
                    'tchmi-user-control-host',
                    PopupUuid,
                    popupParametersPopupControl
                );
                var desktop = TcHmi.Controls.get('Desktop');
                if (desktop && popup) {
                    desktop.addChild(popup);
                }
                var t;
                var timer_is_on = 0;

                function timedCount() {
                        myStopFunction();
                        stopCount();
                }

                function startCount() {
                    if (!timer_is_on) {
                        timer_is_on = 1;
                        t = setTimeout(timedCount, 5000);
                    }
                }

                function stopCount() {
                    clearTimeout(t);
                    timer_is_on = 0;
                }
                startCount();
                function myStopFunction() {
                    TcHmi.Controls.get(popup.__id).destroy();          
                }

                function generateUuidv4 () {
                    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                        var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
                        return v.toString(16);
                    })
                }
                return;
            }            
            TcHmiDisplayName.DisplayDeviceName = DisplayDeviceName;
        })(TcHmiDisplayName = Functions.TcHmiDisplayName || (Functions.TcHmiDisplayName = {}));
        Functions.registerFunctionEx('DisplayDeviceName', 'TcHmi.Functions.TcHmiDisplayName', TcHmiDisplayName.DisplayDeviceName);
    })(Functions = TcHmi.Functions || (TcHmi.Functions = {}));
})(TcHmi);