﻿using System;
using System.Threading;

namespace ManualResetEventTest
{
    class Program
    {
        // true to set the initial state signaled; false to set the initial state to nonsignaled.
        static ManualResetEvent mre = new ManualResetEvent(false);
        static void Main(string[] args)
        {
            new Thread(WriteMethod).Start();

            for (int i = 0; i < 5; i++)
            {
                new Thread(ReadMethod).Start();
            }
            Console.ReadKey();
        }

        public static void  WriteMethod()
        {
            Console.WriteLine("Thread {0} is writting", Thread.CurrentThread.ManagedThreadId);
            //Sets the state of the event to nonsignaled, causing threads to block
            //It will be false in this case since we have initialized with false, see line 8
            mre.Reset();
            Thread.Sleep(5000);
            Console.WriteLine("Thread {0} has completed", Thread.CurrentThread.ManagedThreadId);
            mre.Set();

        }

        public static void ReadMethod()
        {
            Console.WriteLine("Thread {0} is waiting", Thread.CurrentThread.ManagedThreadId);
            mre.WaitOne();
            Thread.Sleep(2000);
            Console.WriteLine("Thread {0} has read", Thread.CurrentThread.ManagedThreadId);
        }
    }
}
